/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.fluid.feature;

import io.ticticboom.mods.mm.port.common.IHandlerCoupling;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidHandlerCoupling
implements IHandlerCoupling {
    private final LazyOptional<IFluidHandler> fromHandler;
    private LazyOptional<IFluidHandler> toHandler;

    public FluidHandlerCoupling(LazyOptional<IFluidHandler> fromHandler, LazyOptional<IFluidHandler> toHandler) {
        this.fromHandler = fromHandler;
        this.toHandler = toHandler;
    }

    @Override
    public void attemptTransfer() {
        this.toHandler.ifPresent(handler -> this.fromHandler.ifPresent(from -> this.attemptTransfer((IFluidHandler)from, (IFluidHandler)handler)));
    }

    private void attemptTransfer(IFluidHandler from, IFluidHandler to) {
        FluidStack extracted = from.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (extracted.isEmpty()) {
            return;
        }
        int remaining = to.fill(extracted, IFluidHandler.FluidAction.EXECUTE);
        if (remaining > 0) {
            from.drain(remaining, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public LazyOptional<IFluidHandler> getFromHandler() {
        return this.fromHandler;
    }

    public LazyOptional<IFluidHandler> getToHandler() {
        return this.toHandler;
    }

    public void setToHandler(LazyOptional<IFluidHandler> toHandler) {
        this.toHandler = toHandler;
    }
}

