/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.structure;

import io.ticticboom.mods.mm.structure.StructureModel;
import io.ticticboom.mods.mm.structure.layout.PositionedLayoutPiece;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.lwjgl.glfw.GLFW;

public class AutoTransform {
    private static Minecraft mc = Minecraft.m_91087_();
    private int lastX = 0;
    private int lastY = 0;
    private double xRotation;
    private double yRotation;
    private double scrollLastPos = 0.0;
    private Vector3i minBound = new Vector3i(Integer.MAX_VALUE);
    private Vector3i maxBound = new Vector3i(Integer.MIN_VALUE);
    private Vector3f pan;
    private Vector3f offset;
    private float scaleFactor;

    public AutoTransform(StructureModel model) {
        for (PositionedLayoutPiece piece : model.layout().getPositionedPieces()) {
            BlockPos pos = piece.pos();
            this.minBound.x = Math.min(pos.m_123341_(), this.minBound.x);
            this.minBound.y = Math.min(pos.m_123342_(), this.minBound.y);
            this.minBound.z = Math.min(pos.m_123343_(), this.minBound.z);
            this.maxBound.x = Math.max(pos.m_123341_(), this.maxBound.x);
            this.maxBound.y = Math.max(pos.m_123342_(), this.maxBound.y);
            this.maxBound.z = Math.max(pos.m_123343_(), this.maxBound.z);
        }
        this.reset();
    }

    public void run(int mouseX, int mouseY) {
        if (this.lastX == 0 && this.lastY == 0) {
            this.lastX = mouseX;
            this.lastY = mouseY;
        }
        if (GLFW.glfwGetMouseButton((long)mc.m_91268_().m_85439_(), (int)1) == 1) {
            this.scaleFactor += ((float)mouseY - (float)this.lastY) * 0.05f;
            this.scaleFactor = Math.max(0.003f, this.scaleFactor);
        }
        if (GLFW.glfwGetMouseButton((long)mc.m_91268_().m_85439_(), (int)2) == 1) {
            double mx = (double)mouseX - (double)this.lastX;
            double my = (double)mouseY - (double)this.lastY;
            this.xRotation += mx;
            this.yRotation += my;
        }
        if (GLFW.glfwGetMouseButton((long)mc.m_91268_().m_85439_(), (int)0) == 1 && GLFW.glfwGetKey((long)mc.m_91268_().m_85439_(), (int)340) == 1) {
            double relMoveX = mouseX - this.lastX;
            double relMoveY = mouseY - this.lastY;
            this.pan.add((float)relMoveX * 0.08f, (float)(-relMoveY) * 0.08f, 0.0f);
        }
        this.offset = new Vector3f(-0.5f, -0.5f, -0.5f);
        this.lastX = mouseX;
        this.lastY = mouseY;
    }

    public Matrix4f getModelTransform() {
        Matrix4f m = new Matrix4f().identity();
        m.translate(this.offset.x, this.offset.y, this.offset.z);
        m.scale(this.scaleFactor);
        return m;
    }

    public Matrix4f getViewTransform() {
        Matrix4f m = new Matrix4f().identity();
        m.translate(this.pan.x, this.pan.y, this.pan.z);
        return m;
    }

    public void reset() {
        this.xRotation = -35.0;
        this.yRotation = 15.0;
        this.lastX = 0;
        this.lastY = 0;
        this.scaleFactor = 1.003f;
        this.pan = new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public int getLastX() {
        return this.lastX;
    }

    public int getLastY() {
        return this.lastY;
    }

    public double getXRotation() {
        return this.xRotation;
    }

    public double getYRotation() {
        return this.yRotation;
    }

    public double getScrollLastPos() {
        return this.scrollLastPos;
    }

    public Vector3i getMinBound() {
        return this.minBound;
    }

    public Vector3i getMaxBound() {
        return this.maxBound;
    }

    public Vector3f getPan() {
        return this.pan;
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setLastX(int lastX) {
        this.lastX = lastX;
    }

    public void setLastY(int lastY) {
        this.lastY = lastY;
    }

    public void setXRotation(double xRotation) {
        this.xRotation = xRotation;
    }

    public void setYRotation(double yRotation) {
        this.yRotation = yRotation;
    }

    public void setScrollLastPos(double scrollLastPos) {
        this.scrollLastPos = scrollLastPos;
    }

    public void setMinBound(Vector3i minBound) {
        this.minBound = minBound;
    }

    public void setMaxBound(Vector3i maxBound) {
        this.maxBound = maxBound;
    }

    public void setPan(Vector3f pan) {
        this.pan = pan;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    public void setScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }
}

