/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.structure;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import io.ticticboom.mods.mm.client.RenderUtil;
import io.ticticboom.mods.mm.client.gui.util.GuiPos;
import net.minecraft.client.Minecraft;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class GuiRenderEnvSetup {
    private GuiPos viewportPos;
    private static Minecraft mc = Minecraft.m_91087_();

    public void preRender(float xRot, float yRot, int extent, Matrix4f viewMatrix) {
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        float s = 95.5f;
        modelViewStack.m_85841_(s, s, s);
        modelViewStack.m_252880_(0.0f, 0.0f, (float)(100 - extent));
        modelViewStack.m_252931_(viewMatrix);
        Quaternionf quat = new Quaternionf().rotateXYZ((float)Math.toRadians(xRot), (float)Math.toRadians(yRot), 0.0f);
        modelViewStack.m_252781_(quat);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.backupProjectionMatrix();
        Matrix4f proj = new Matrix4f().identity();
        proj.setPerspective((float)Math.toRadians(85.0), (float)this.viewportPos.w() / (float)this.viewportPos.h(), 0.01f, 1000000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)proj, (VertexSorting)VertexSorting.f_276450_);
        this.setupViewport();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Lighting.m_84931_();
    }

    private void setupViewport() {
        RenderUtil.setViewport(this.viewportPos);
    }

    public void postRender() {
        RenderSystem.restoreProjectionMatrix();
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85849_();
        Lighting.m_84930_();
        RenderSystem.disableBlend();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableDepthTest();
    }

    public GuiPos getViewportPos() {
        return this.viewportPos;
    }

    public void setViewportPos(GuiPos viewportPos) {
        this.viewportPos = viewportPos;
    }
}

