/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.client.gui.util.GuiPos;
import io.ticticboom.mods.mm.client.structure.GuiCountedItemStack;
import io.ticticboom.mods.mm.client.structure.GuiStructureRenderer;
import io.ticticboom.mods.mm.client.util.TextRenderUtil;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.compat.jei.SlotGridEntry;
import io.ticticboom.mods.mm.controller.MMControllerRegistry;
import io.ticticboom.mods.mm.item.BlueprintItem;
import io.ticticboom.mods.mm.setup.MMRegisters;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fc;
import org.joml.Vector2i;
import org.joml.Vector4f;

public class MMStructureCategory
implements IRecipeCategory<StructureModel> {
    public static final RecipeType<StructureModel> RECIPE_TYPE = RecipeType.create((String)"mm", (String)"structure", StructureModel.class);
    private final IGuiHelper helper;
    private static final Vector2i PANEL_SIZE = new Vector2i(162, 170);
    private static final Vector2i RENDER_SIZE = new Vector2i(160, 120);
    private final IDrawableStatic background;
    private final MutableComponent title = Component.m_237113_((String)"MM Structure");

    public MMStructureCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(Ref.UiTextures.GUI_LARGE_JEI, 0, 0, 162, 121);
    }

    @NotNull
    public RecipeType<StructureModel> getRecipeType() {
        return RECIPE_TYPE;
    }

    public ResourceLocation getRegistryName(StructureModel recipe) {
        return recipe.id();
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    public int getWidth() {
        return MMStructureCategory.PANEL_SIZE.x;
    }

    public int getHeight() {
        return MMStructureCategory.PANEL_SIZE.y;
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableItemStack(((BlueprintItem)((Object)MMRegisters.BLUEPRINT.get())).m_7968_());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StructureModel recipe, IFocusGroup focuses) {
        IIngredientAcceptor catalysts = builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST);
        for (ResourceLocation id : recipe.controllerIds().getIds()) {
            Item controller = MMControllerRegistry.getControllerItem(id);
            if (controller == null) continue;
            catalysts.addItemStack(controller.m_7968_());
        }
        GuiStructureRenderer guiRenderer = recipe.getGuiRenderer();
        guiRenderer.resetTransforms();
        guiRenderer.init();
        List<GuiCountedItemStack> countedItemStacks = recipe.getCountedItemStacks();
        SlotGrid grid = new SlotGrid(20, 20, 8, 3, 1, 130);
        recipe.setGrid(grid);
        for (GuiCountedItemStack countedItemStack : countedItemStacks) {
            SlotGridEntry next = grid.next();
            next.setUsed();
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, next.x, next.y);
            slot.addItemStacks(countedItemStack.getStacks());
            slot.addRichTooltipCallback((a, b) -> b.add((FormattedText)countedItemStack.getDetail()));
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStack(((BlueprintItem)((Object)MMRegisters.BLUEPRINT.get())).getStructureInstance(recipe.id()));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(((BlueprintItem)((Object)MMRegisters.BLUEPRINT.get())).getStructureInstance(recipe.id()));
    }

    public void draw(StructureModel recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        this.renderStructure(recipe, guiGraphics, mouseX, mouseY);
        IDrawableStatic slotDrawable = this.helper.getSlotDrawable();
        for (SlotGridEntry slot : recipe.getGrid().getSlots()) {
            slotDrawable.draw(guiGraphics, slot.x - 1, slot.y - 1);
        }
        TextRenderUtil.renderWordWrapLimit(guiGraphics, recipe.name(), 5, 5, MMStructureCategory.RENDER_SIZE.x - 5, 2, -1);
    }

    private void renderStructure(StructureModel recipe, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Vector2i pos = this.getGuiPosition(guiGraphics.m_280168_());
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_166856_();
        GuiStructureRenderer renderer = recipe.getGuiRenderer();
        renderer.setViewport(GuiPos.of(pos.x + 1, pos.y + 1, MMStructureCategory.RENDER_SIZE.x, MMStructureCategory.RENDER_SIZE.y));
        renderer.render(guiGraphics, (int)mouseX, (int)mouseY);
        guiGraphics.m_280168_().m_85849_();
    }

    private Vector2i getGuiPosition(PoseStack poseStack) {
        Vector4f transformedPosition = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        transformedPosition.mul((Matrix4fc)poseStack.m_85850_().m_252922_());
        return new Vector2i((int)transformedPosition.x, (int)transformedPosition.y);
    }
}

