/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.ticticboom.mods.mm.util.ParserUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class IdList {
    private final List<ResourceLocation> ids;

    public IdList(List<ResourceLocation> ids) {
        this.ids = ids;
    }

    public boolean contains(ResourceLocation id) {
        return this.ids.contains(id);
    }

    public static IdList parse(JsonElement json) {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        if (json.isJsonArray()) {
            JsonArray elems = json.getAsJsonArray();
            for (JsonElement elem : elems) {
                ids.add(ParserUtils.parseId(elem));
            }
        } else {
            ids.add(ParserUtils.parseId(json));
        }
        return new IdList(ids);
    }

    public JsonArray serialize() {
        JsonArray ids = new JsonArray();
        for (ResourceLocation id : this.ids) {
            ids.add(id.toString());
        }
        return ids;
    }

    public List<ResourceLocation> getIds() {
        return this.ids;
    }
}

