/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.net.packet;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.ticticboom.mods.mm.recipe.MachineRecipeManager;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class ProcessesSyncPkt {
    public Map<ResourceLocation, JsonElement> recipes;

    public ProcessesSyncPkt(Map<ResourceLocation, RecipeModel> recipes) {
        this.recipes = new HashMap<ResourceLocation, JsonElement>();
        for (Map.Entry<ResourceLocation, RecipeModel> entry : recipes.entrySet()) {
            this.recipes.put(entry.getKey(), (JsonElement)entry.getValue().config());
        }
    }

    protected ProcessesSyncPkt() {
    }

    public static void encode(ProcessesSyncPkt packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.recipes.size());
        for (Map.Entry<ResourceLocation, JsonElement> entry : packet.recipes.entrySet()) {
            buf.m_130085_(entry.getKey());
            buf.m_130070_(entry.getValue().toString());
        }
    }

    public static ProcessesSyncPkt decode(FriendlyByteBuf buf) {
        ProcessesSyncPkt packet = new ProcessesSyncPkt();
        packet.recipes = new HashMap<ResourceLocation, JsonElement>();
        int count = buf.m_130242_();
        for (int i = 0; i < count; ++i) {
            packet.recipes.put(buf.m_130281_(), JsonParser.parseString((String)buf.m_130277_()));
        }
        return packet;
    }

    public static void handle(ProcessesSyncPkt packet, Supplier<NetworkEvent.Context> context) {
        ProcessesSyncPkt.handler(packet);
    }

    public static void handler(ProcessesSyncPkt packet) {
        MachineRecipeManager.recieveRecipes(packet.recipes);
    }
}

