/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.net.packet;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.ticticboom.mods.mm.structure.StructureManager;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class StructureSyncPkt {
    public Map<ResourceLocation, JsonElement> structures;

    public StructureSyncPkt(Map<ResourceLocation, StructureModel> structures) {
        this.structures = new HashMap<ResourceLocation, JsonElement>();
        for (Map.Entry<ResourceLocation, StructureModel> structure : structures.entrySet()) {
            this.structures.put(structure.getKey(), (JsonElement)structure.getValue().getConfig());
        }
    }

    protected StructureSyncPkt() {
    }

    public static void encode(StructureSyncPkt packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.structures.size());
        for (Map.Entry<ResourceLocation, JsonElement> strcture : packet.structures.entrySet()) {
            String string = strcture.getValue().toString();
            buf.m_130085_(strcture.getKey());
            buf.m_130070_(string);
        }
    }

    public static StructureSyncPkt decode(FriendlyByteBuf buf) {
        StructureSyncPkt packet = new StructureSyncPkt();
        int initialCapacity = buf.readInt();
        packet.structures = new HashMap<ResourceLocation, JsonElement>(initialCapacity);
        for (int i = 0; i < initialCapacity; ++i) {
            ResourceLocation key = buf.m_130281_();
            String string = buf.m_130277_();
            packet.structures.put(key, JsonParser.parseString((String)string));
        }
        return packet;
    }

    public static void handle(StructureSyncPkt packet, Supplier<NetworkEvent.Context> context) {
        StructureSyncPkt.handler(packet);
    }

    public static void handler(StructureSyncPkt packet) {
        StructureManager.receiveStructures(packet.structures);
        StructureManager.validateAllPieces();
    }
}

