/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortBlock;
import io.ticticboom.mods.mm.port.IPortIngredient;
import io.ticticboom.mods.mm.port.PortType;
import io.ticticboom.mods.mm.port.botania.mana.BotaniaManaPortType;
import io.ticticboom.mods.mm.port.energy.EnergyPortType;
import io.ticticboom.mods.mm.port.fluid.FluidPortType;
import io.ticticboom.mods.mm.port.item.ItemPortType;
import io.ticticboom.mods.mm.port.kinetic.CreateKineticPortType;
import io.ticticboom.mods.mm.port.mekanism.gas.MekanismGasPortType;
import io.ticticboom.mods.mm.port.mekanism.infuse.MekanismInfusePortType;
import io.ticticboom.mods.mm.port.mekanism.pigment.MekanismPigmentPortType;
import io.ticticboom.mods.mm.port.mekanism.slurry.MekanismSlurryPortType;
import io.ticticboom.mods.mm.port.pneumaticcraft.air.PneumaticAirPortType;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import io.ticticboom.mods.mm.util.ParserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public class MMPortRegistry {
    private static Map<ResourceLocation, PortType> PORT_TYPES = new HashMap<ResourceLocation, PortType>();
    public static List<RegistryGroupHolder> PORTS = new ArrayList<RegistryGroupHolder>();

    public static void init() {
        MMPortRegistry.register(Ref.Ports.ITEM, new ItemPortType());
        MMPortRegistry.register(Ref.Ports.FLUID, new FluidPortType());
        MMPortRegistry.register(Ref.Ports.ENERGY, new EnergyPortType());
        if (ModList.get().isLoaded("mekanism")) {
            MMPortRegistry.register(Ref.Ports.MEK_GAS, new MekanismGasPortType());
            MMPortRegistry.register(Ref.Ports.MEK_SLURRY, new MekanismSlurryPortType());
            MMPortRegistry.register(Ref.Ports.MEK_PIGMENT, new MekanismPigmentPortType());
            MMPortRegistry.register(Ref.Ports.MEK_INFUSE, new MekanismInfusePortType());
        }
        if (ModList.get().isLoaded("create")) {
            MMPortRegistry.register(Ref.Ports.CREATE_KINETIC, new CreateKineticPortType());
        }
        if (ModList.get().isLoaded("pneumaticcraft")) {
            MMPortRegistry.register(Ref.Ports.PNEUMATIC_AIR, new PneumaticAirPortType());
        }
        if (ModList.get().isLoaded("botania")) {
            MMPortRegistry.register(Ref.Ports.BOTANIA_MANA, new BotaniaManaPortType());
        }
    }

    public static PortType get(ResourceLocation id) {
        return PORT_TYPES.get(id);
    }

    public static void register(ResourceLocation id, PortType type) {
        PORT_TYPES.put(id, type);
    }

    public static Collection<PortType> getPortBlocks() {
        return PORT_TYPES.values();
    }

    public static IPortIngredient parseIngredient(JsonObject json) {
        ResourceLocation type = ParserUtils.parseId(json, "type");
        return PORT_TYPES.get(type).getParser().parseRecipeIngredient(json);
    }

    public static List<PortModel> getPortModelsForControllerId(ResourceLocation id) {
        return PORTS.stream().filter(x -> {
            Object patt2862$temp = x.getBlock().get();
            if (patt2862$temp instanceof IPortBlock) {
                IPortBlock bp = (IPortBlock)patt2862$temp;
                return bp.getModel().controllerIds().contains(id);
            }
            return false;
        }).map(x -> ((IPortBlock)x.getBlock().get()).getModel()).toList();
    }
}

