/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.botania.mana.register;

import com.mojang.blaze3d.systems.RenderSystem;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.cap.BotaniaCapabilities;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortBlockEntity;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.botania.mana.BotaniaManaPortStorage;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaTabletItem;

public class BotaniaManaPortBlockEntity
extends BlockEntity
implements ManaPool,
IPortBlockEntity {
    private final PortModel model;
    private final RegistryGroupHolder groupHolder;
    private final BotaniaManaPortStorage storage;
    private final WandHud wandHud = new WandHud(this);
    private final LazyOptional<WandHUD> wandHudCap = LazyOptional.of(() -> this.wandHud);
    private final LazyOptional<ManaReceiver> manaReceiverCap = LazyOptional.of(() -> this);

    public BotaniaManaPortBlockEntity(PortModel model, RegistryGroupHolder groupHolder, BlockPos pos, BlockState state) {
        super((BlockEntityType)groupHolder.getBe().get(), pos, state);
        this.model = model;
        this.groupHolder = groupHolder;
        this.storage = (BotaniaManaPortStorage)model.config().createPortStorage(this::m_6596_);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BotaniaCapabilities.WAND_HUD) {
            return this.wandHudCap.cast();
        }
        if (cap == BotaniaCapabilities.MANA_RECEIVER) {
            return this.manaReceiverCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick() {
        boolean inNetwork = ManaNetworkHandler.instance.isPoolIn(this.f_58857_, (ManaPool)this);
        if (!inNetwork && !this.m_58901_()) {
            BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent((ManaReceiver)this, ManaBlockType.POOL, ManaNetworkAction.ADD);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent((ManaReceiver)this, ManaBlockType.POOL, ManaNetworkAction.REMOVE);
        this.wandHudCap.invalidate();
        this.manaReceiverCap.invalidate();
    }

    @Override
    public PortModel getModel() {
        return this.model;
    }

    @Override
    public IPortStorage getStorage() {
        return this.storage;
    }

    @Override
    public boolean isInput() {
        return this.model.input();
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Botania Mana Port");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return null;
    }

    public boolean isOutputtingPower() {
        return !this.model.input();
    }

    public int getMaxMana() {
        return this.storage.getCapacity();
    }

    public Optional<DyeColor> getColor() {
        return Optional.of(DyeColor.CYAN);
    }

    public void setColor(Optional<DyeColor> optional) {
    }

    public Level getManaReceiverLevel() {
        return this.f_58857_;
    }

    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    public int getCurrentMana() {
        return this.storage.getStored();
    }

    public boolean isFull() {
        return this.storage.getStored() >= this.storage.getCapacity();
    }

    public void receiveMana(int i) {
        if (i < 0) {
            this.storage.extractMana(i, false);
        } else {
            this.storage.receiveMana(i, false);
        }
    }

    public boolean canReceiveManaFromBursts() {
        return this.model.input();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(Ref.NBT_STORAGE_KEY, (Tag)this.storage.save(new CompoundTag()));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storage.load(tag.m_128469_(Ref.NBT_STORAGE_KEY));
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static class WandHud
    implements WandHUD {
        private final BotaniaManaPortBlockEntity pool;

        public WandHud(BotaniaManaPortBlockEntity pool) {
            this.pool = pool;
        }

        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack poolStack = new ItemStack((ItemLike)this.pool.m_58900_().m_60734_());
            String name = poolStack.m_41786_().getString();
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            int width = Math.max(102, mc.f_91062_.m_92895_(name)) + 4;
            RenderHelper.renderHUDBox((GuiGraphics)gui, (int)(centerX - width / 2), (int)(centerY + 8), (int)(centerX + width / 2), (int)(centerY + 48));
            BotaniaAPIClient.instance().drawSimpleManaHUD(gui, 38399, this.pool.getCurrentMana(), this.pool.getMaxMana(), name);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            int arrowU = this.pool.isOutputtingPower() ? 22 : 0;
            int arrowV = 38;
            RenderHelper.drawTexturedModalRect((GuiGraphics)gui, (ResourceLocation)HUDHandler.manaBar, (int)(centerX - 11), (int)(centerY + 30), (int)arrowU, (int)arrowV, (int)22, (int)15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack tablet = new ItemStack((ItemLike)BotaniaItems.manaTablet);
            ManaTabletItem.setStackCreative((ItemStack)tablet);
            gui.m_280480_(tablet, centerX - 31, centerY + 30);
            gui.m_280480_(poolStack, centerX + 15, centerY + 30);
            RenderSystem.disableBlend();
        }
    }
}

