/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.common;

import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.common.IHandlerCoupling;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractPortAutoPushFeature<TCoupling extends IHandlerCoupling> {
    protected final BlockEntity portBlockEntity;
    protected final PortModel model;
    protected final HashMap<BlockPos, TCoupling> autoPushNeighbors = new HashMap();

    public AbstractPortAutoPushFeature(BlockEntity portBlockEntity, PortModel model) {
        this.portBlockEntity = portBlockEntity;
        this.model = model;
    }

    public void tick() {
        Level level = this.portBlockEntity.m_58904_();
        if (level == null) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        for (IHandlerCoupling cap : this.autoPushNeighbors.values()) {
            cap.attemptTransfer();
        }
    }

    public void tryAddNeighboringHandlers() {
        if (!this.portBlockEntity.m_58898_()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos otherPos = this.portBlockEntity.m_58899_().m_5484_(direction, 1);
            this.tryAddNeighborHandler(otherPos, direction.m_122424_());
        }
    }

    public void onLoad() {
        this.tryAddNeighboringHandlers();
    }

    protected abstract void tryAddNeighborHandler(BlockPos var1, Direction var2);
}

