/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.energy;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageFactory;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import io.ticticboom.mods.mm.port.energy.EnergyPortStorage;
import io.ticticboom.mods.mm.port.energy.EnergyPortStorageModel;

public class EnergyPortStorageFactory
implements IPortStorageFactory {
    private final EnergyPortStorageModel model;

    public EnergyPortStorageFactory(EnergyPortStorageModel model) {
        this.model = model;
    }

    @Override
    public IPortStorage createPortStorage(INotifyChangeFunction changed) {
        return new EnergyPortStorage(this.model, changed);
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("capacity", (Number)this.model.capacity());
        json.addProperty("maxReceive", (Number)this.model.maxReceive());
        json.addProperty("maxExtract", (Number)this.model.maxExtract());
        return json;
    }

    @Override
    public IPortStorageModel getModel() {
        return this.model;
    }
}

