/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.config.MMConfig;
import io.ticticboom.mods.mm.port.IPortIngredient;
import io.ticticboom.mods.mm.port.IPortParser;
import io.ticticboom.mods.mm.port.IPortStorageFactory;
import io.ticticboom.mods.mm.port.fluid.FluidPortIngredient;
import io.ticticboom.mods.mm.port.fluid.FluidPortStorageFactory;
import io.ticticboom.mods.mm.port.fluid.FluidPortStorageModel;
import io.ticticboom.mods.mm.util.ParserUtils;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class FluidPortParser
implements IPortParser {
    @Override
    public IPortStorageFactory parseStorage(JsonObject json) {
        int rows = json.get("rows").getAsInt();
        int columns = json.get("columns").getAsInt();
        int slotCapacity = json.get("slotCapacity").getAsInt();
        Supplier<Boolean> autoPush = ParserUtils.parseOrDefaultSupplier(json, "autoPush", () -> MMConfig.DEFAULT_PORT_AUTO_PUSH, JsonElement::getAsBoolean);
        return new FluidPortStorageFactory(new FluidPortStorageModel(rows, columns, slotCapacity, autoPush));
    }

    @Override
    public IPortIngredient parseRecipeIngredient(JsonObject json) {
        ResourceLocation fluidId = ParserUtils.parseId(json, "fluid");
        int amount = json.get("amount").getAsInt();
        return new FluidPortIngredient(fluidId, amount);
    }
}

