/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.fluid;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageFactory;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import io.ticticboom.mods.mm.port.fluid.FluidPortStorage;
import io.ticticboom.mods.mm.port.fluid.FluidPortStorageModel;

public class FluidPortStorageFactory
implements IPortStorageFactory {
    private final FluidPortStorageModel model;

    public FluidPortStorageFactory(FluidPortStorageModel model) {
        this.model = model;
    }

    @Override
    public IPortStorage createPortStorage(INotifyChangeFunction changed) {
        return new FluidPortStorage(this.model, changed);
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("rows", (Number)this.model.rows());
        json.addProperty("columns", (Number)this.model.columns());
        json.addProperty("slotCapacity", (Number)this.model.slotCapacity());
        return json;
    }

    @Override
    public IPortStorageModel getModel() {
        return this.model;
    }
}

