/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.item;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.logging.log4j.Logger;

public class ItemPortHandler
extends ItemStackHandler {
    public static Codec<List<ItemStack>> STACKS_CODEC = Codec.list((Codec)ItemStack.f_41582_);
    private final INotifyChangeFunction changed;

    public ItemPortHandler(int size, INotifyChangeFunction changed) {
        super(size);
        this.changed = changed;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public Tag serializeStacks() {
        DataResult tag = (DataResult)NbtOps.f_128958_.withEncoder(STACKS_CODEC).apply(this.stacks);
        return (Tag)tag.getOrThrow(false, arg_0 -> ((Logger)Ref.LOG).error(arg_0));
    }

    public void deserializeStacks(Tag nbt) {
        DataResult res = (DataResult)NbtOps.f_128958_.withDecoder(STACKS_CODEC).apply(nbt);
        Pair pair = (Pair)res.getOrThrow(false, arg_0 -> ((Logger)Ref.LOG).error(arg_0));
        this.stacks.clear();
        List list = (List)pair.getFirst();
        for (int i = 0; i < list.size(); ++i) {
            this.stacks.set(i, (Object)((ItemStack)list.get(i)));
        }
    }

    protected void onContentsChanged(int slot) {
        this.changed.call();
    }
}

