/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import io.ticticboom.mods.mm.cap.MMCapabilities;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import io.ticticboom.mods.mm.port.item.ItemPortContainer;
import io.ticticboom.mods.mm.port.item.ItemPortHandler;
import io.ticticboom.mods.mm.port.item.ItemPortStorageModel;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class ItemPortStorage
implements IPortStorage {
    private final ItemPortHandler handler;
    private final LazyOptional<ItemPortHandler> handlerLazyOptional;
    private final ItemPortStorageModel model;
    private final UUID uid = UUID.randomUUID();

    public ItemPortStorage(ItemPortStorageModel model, INotifyChangeFunction changed) {
        this.model = model;
        this.handler = new ItemPortHandler(model.rows() * model.columns(), changed);
        this.handlerLazyOptional = LazyOptional.of(() -> this.handler);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (this.hasCapability(capability)) {
            return this.handlerLazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public <T> boolean hasCapability(Capability<T> capability) {
        return capability == MMCapabilities.ITEM;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        Tag compoundTag = this.handler.serializeStacks();
        tag.m_128365_("handler", compoundTag);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        Tag compoundTag = tag.m_128423_("handler");
        this.handler.deserializeStacks(compoundTag);
    }

    @Override
    public IPortStorageModel getStorageModel() {
        return this.model;
    }

    @Override
    public UUID getStorageUid() {
        return this.uid;
    }

    @Override
    public JsonObject debugDump() {
        JsonObject json = new JsonObject();
        json.addProperty("uid", this.uid.toString());
        json.addProperty("rows", (Number)this.model.rows());
        json.addProperty("columns", (Number)this.model.columns());
        JsonArray stacksJson = new JsonArray();
        for (ItemStack stack : this.handler.getStacks()) {
            DataResult res = (DataResult)JsonOps.INSTANCE.withEncoder((Encoder)ItemStack.f_41582_).apply(stack);
            if (res.result().isPresent()) {
                stacksJson.add((JsonElement)res.result().get());
                continue;
            }
            stacksJson.add("Error Serializing Item Stack");
        }
        return json;
    }

    @Override
    public void setupContainer(AbstractContainerMenu container, Inventory inv, PortModel portModel) {
        int columns = this.model.columns();
        int rows = this.model.rows();
        int offsetX = (162 - columns * 18) / 2 + 8;
        int offsetY = (108 - rows * 18) / 2 + 8;
        ItemPortContainer portInv = new ItemPortContainer(this.handler);
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                container.m_38897_(new Slot((Container)portInv, y * columns + x, x * 18 + offsetX, y * 18 + offsetY));
            }
        }
        IPortStorage.super.setupContainer(container, inv, portModel);
    }

    public int canExtract(Predicate<ItemStack> item, int count) {
        return this.handlerExtract(item, count, true);
    }

    public int extract(Predicate<ItemStack> item, int count) {
        return this.handlerExtract(item, count, false);
    }

    private int handlerExtract(Predicate<ItemStack> item, int count, boolean simulate) {
        int remaining = count;
        for (int slot = 0; slot < this.handler.getSlots(); ++slot) {
            ItemStack stack = this.handler.getStackInSlot(slot);
            if (!item.test(stack)) continue;
            ItemStack extracted = this.handler.extractItem(slot, remaining, simulate);
            remaining -= extracted.m_41613_();
        }
        return remaining;
    }

    public int canInsert(Item item, int count) {
        return this.handlerInsert(item, count, true);
    }

    public int insert(Item item, int count) {
        return this.handlerInsert(item, count, false);
    }

    private int handlerInsert(Item item, int count, boolean simulate) {
        int remainingToInsert = count;
        for (int slot = 0; slot < this.handler.getSlots(); ++slot) {
            int toInsert = Math.min(this.handler.getSlotLimit(slot), remainingToInsert);
            ItemStack remains = this.handler.insertItem(slot, new ItemStack((ItemLike)item, toInsert), simulate);
            remainingToInsert -= toInsert - remains.m_41613_();
        }
        return remainingToInsert;
    }

    public ItemPortHandler getHandler() {
        return this.handler;
    }
}

