/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.recipe.output.simple;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.compat.jei.SlotGridEntry;
import io.ticticboom.mods.mm.port.IPortIngredient;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import io.ticticboom.mods.mm.recipe.output.IRecipeOutputEntry;
import io.ticticboom.mods.mm.util.ChanceUtils;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class SimpleRecipeOutputEntry
implements IRecipeOutputEntry {
    private final IPortIngredient ingredient;
    private final double chance;
    private final boolean perTick;
    private boolean shouldRun = true;

    public SimpleRecipeOutputEntry(IPortIngredient ingredient, double chance, boolean perTick) {
        this.ingredient = ingredient;
        this.chance = chance;
        this.perTick = perTick;
    }

    @Override
    public boolean canOutput(Level level, RecipeStorages storages, RecipeStateModel state) {
        this.shouldRun = ChanceUtils.shouldProceed(this.chance);
        return this.ingredient.canOutput(level, storages, state);
    }

    @Override
    public void output(Level level, RecipeStorages storages, RecipeStateModel state) {
        if (!this.perTick && this.shouldRun) {
            this.ingredient.output(level, storages, state);
        }
    }

    @Override
    public void processTick(Level level, RecipeStorages storages, RecipeStateModel state) {
        if (this.perTick && this.shouldRun) {
            this.ingredient.output(level, storages, state);
        }
        this.ingredient.outputTick(level, storages, state);
    }

    @Override
    public void ditchRecipe(Level level, RecipeStorages storages, RecipeStateModel state) {
        this.ingredient.ditchRecipe(level, storages, state);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeModel model, IFocusGroup focus, IJeiHelpers helpers, SlotGrid grid) {
        SlotGridEntry slot = grid.next();
        slot.setUsed();
        IRecipeSlotBuilder rSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, slot.getInnerX(), slot.getInnerY());
        this.ingredient.setRecipe(builder, model, focus, helpers, grid, rSlot);
        String fmtChance = String.format("%.2f", this.chance * 100.0) + "% Chance of Output";
        rSlot.addTooltipCallback((v, list) -> {
            if (this.chance < 1.0) {
                list.add(Component.m_237113_((String)fmtChance).m_130940_(ChatFormatting.DARK_AQUA));
            }
            if (this.perTick) {
                list.add(Component.m_237113_((String)"Output Per Tick").m_130940_(ChatFormatting.DARK_AQUA));
            }
        });
    }

    @Override
    public JsonObject debugExpected(Level level, RecipeStorages storages, RecipeStateModel model, JsonObject json) {
        json.addProperty("chance", (Number)this.chance);
        json.addProperty("perTick", Boolean.valueOf(this.perTick));
        json.add("ingredient", (JsonElement)this.ingredient.debugOutput(level, storages, new JsonObject()));
        return json;
    }
}

