/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.setup.loader;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.compat.interop.MMInteropManager;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.MMPortRegistry;
import io.ticticboom.mods.mm.port.PortType;
import io.ticticboom.mods.mm.setup.loader.AbstractConfigLoader;
import java.util.ArrayList;
import java.util.List;

public class PortLoader
extends AbstractConfigLoader<PortModel> {
    public static void loadAll() {
        new PortLoader().load();
    }

    @Override
    protected String getConfigPath() {
        return "ports";
    }

    @Override
    protected List<PortModel> parseModels(List<JsonObject> jsons) {
        ArrayList<PortModel> result = new ArrayList<PortModel>();
        result.ensureCapacity(jsons.size() * 2);
        for (JsonObject json : jsons) {
            PortModel inputModel = PortModel.parse(json, true);
            PortModel outputModel = PortModel.parse(json, false);
            result.add(inputModel);
            result.add(outputModel);
        }
        return result;
    }

    @Override
    protected void registerModels(List<PortModel> portModels) {
        PortType portType;
        for (PortModel portModel : portModels) {
            portType = MMPortRegistry.get(portModel.type());
            portType.register(portModel);
        }
        if (MMInteropManager.KUBEJS.isPresent()) {
            for (PortModel portModel : MMInteropManager.KUBEJS.get().postRegisterPorts()) {
                portType = MMPortRegistry.get(portModel.type());
                portType.register(portModel);
            }
        }
    }
}

