/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.structure;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.client.structure.GuiBlockRenderer;
import io.ticticboom.mods.mm.client.structure.GuiCountedItemStack;
import io.ticticboom.mods.mm.client.structure.GuiStructureLayoutPiece;
import io.ticticboom.mods.mm.client.structure.GuiStructureRenderer;
import io.ticticboom.mods.mm.client.structure.PositionedCyclingBlockRenderer;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.controller.MMControllerRegistry;
import io.ticticboom.mods.mm.model.IdList;
import io.ticticboom.mods.mm.piece.StructurePieceSetupMetadata;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import io.ticticboom.mods.mm.structure.attachment.StructureAttachments;
import io.ticticboom.mods.mm.structure.layout.PositionedLayoutPiece;
import io.ticticboom.mods.mm.structure.layout.StructureLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class StructureModel {
    private final ResourceLocation id;
    private final String name;
    private final IdList controllerIds;
    private final StructureLayout layout;
    private final StructureAttachments attachments;
    private final JsonObject config;
    @OnlyIn(value=Dist.CLIENT)
    private GuiStructureRenderer renderer;
    @OnlyIn(value=Dist.CLIENT)
    private List<GuiCountedItemStack> countedPartItems;
    @OnlyIn(value=Dist.CLIENT)
    private SlotGrid grid;

    public StructureModel(ResourceLocation id, String name, IdList controllerIds, StructureLayout layout, StructureAttachments attachments, JsonObject config) {
        this.id = id;
        this.name = name;
        this.controllerIds = controllerIds;
        this.layout = layout;
        this.attachments = attachments;
        this.config = config;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.renderer = new GuiStructureRenderer(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public PositionedCyclingBlockRenderer controllerUiRenderer() {
        BlockPos pos = new BlockPos(0, 0, 0);
        List<ResourceLocation> ids = this.controllerIds.getIds();
        ArrayList<GuiBlockRenderer> res = new ArrayList<GuiBlockRenderer>();
        for (ResourceLocation id : ids) {
            Block controllerBlock = MMControllerRegistry.getControllerBlock(id);
            GuiBlockRenderer gbr = new GuiBlockRenderer(controllerBlock, List.of());
            gbr.setupAt(pos);
            res.add(gbr);
        }
        return new PositionedCyclingBlockRenderer((List<GuiBlockRenderer>)res, pos);
    }

    public static StructureModel parse(JsonObject json, ResourceLocation structureId) {
        String name = json.get("name").getAsString();
        StructureLayout layout = StructureLayout.parse(json, structureId);
        IdList ids = IdList.parse(json.get("controllerIds"));
        StructureAttachments attachments = StructureAttachments.parse(json);
        return new StructureModel(structureId, name, ids, layout, attachments, json);
    }

    public static JsonObject paramsToJson(ResourceLocation id, String name, IdList controllerIds, StructureLayout layout) {
        JsonObject json = new JsonObject();
        json.addProperty("id", id.toString());
        json.addProperty("name", name);
        json.add("controllerIds", (JsonElement)controllerIds.serialize());
        layout.serialize(json);
        return json;
    }

    public void validate() {
        StructurePieceSetupMetadata meta = new StructurePieceSetupMetadata(this.id, this);
        this.layout.validate(meta);
        this.attachments.validate(meta);
    }

    public boolean formed(Level level, BlockPos controllerPos) {
        return this.layout.formed(level, controllerPos, this);
    }

    public RecipeStorages getStorages(Level level, BlockPos controllerPos) {
        return this.layout.getRecipeStorages(level, controllerPos, this);
    }

    public JsonObject debugFormed(Level level, BlockPos controllerPos) {
        JsonObject json = new JsonObject();
        JsonObject debugLayout = this.layout.debugFormed(level, controllerPos, this);
        json.addProperty("structureId", this.id.toString());
        json.addProperty("name", this.name);
        json.add("controllerIds", (JsonElement)this.controllerIds.serialize());
        json.add("layout", (JsonElement)debugLayout);
        return json;
    }

    public JsonObject debugSerialize() {
        JsonObject json = new JsonObject();
        json.addProperty("structureId", this.id.toString());
        json.addProperty("name", this.name);
        json.add("controllerIds", (JsonElement)this.controllerIds.serialize());
        return json;
    }

    @OnlyIn(value=Dist.CLIENT)
    public GuiStructureRenderer getGuiRenderer() {
        return this.renderer;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public String debugPath() {
        return this.id.m_135827_() + "/" + this.id.m_135815_() + ".json";
    }

    public String name() {
        return this.name;
    }

    public IdList controllerIds() {
        return this.controllerIds;
    }

    public StructureLayout layout() {
        return this.layout;
    }

    public List<GuiCountedItemStack> getCountedItemStacks() {
        if (this.countedPartItems != null) {
            return this.countedPartItems;
        }
        HashMap<String, GuiCountedItemStack> result = new HashMap<String, GuiCountedItemStack>();
        for (PositionedLayoutPiece positionedPiece : this.layout.getPositionedPieces()) {
            GuiStructureLayoutPiece guiPiece = positionedPiece.piece().getGuiPiece();
            List<ItemStack> blocks = guiPiece.getBlocks().stream().map(x -> x.m_5456_().m_7968_()).toList();
            String valueId = positionedPiece.piece().getValueId();
            if (!result.containsKey(valueId)) {
                result.put(valueId, new GuiCountedItemStack(1, blocks, guiPiece.getDisplay(), valueId));
                continue;
            }
            ((GuiCountedItemStack)result.get(valueId)).addCount(1);
        }
        this.countedPartItems = new ArrayList(result.values());
        ArrayList<ItemStack> controllerList = new ArrayList<ItemStack>();
        for (ResourceLocation controller : this.controllerIds.getIds()) {
            Block controllerBlock = MMControllerRegistry.getControllerBlock(controller);
            controllerList.add(controllerBlock.m_5456_().m_7968_());
        }
        this.countedPartItems.add(new GuiCountedItemStack(1, controllerList, (Component)Component.m_237113_((String)"Controller").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), "C"));
        return this.countedPartItems;
    }

    public String toString() {
        return "StructureModel{id=" + String.valueOf(this.id) + ", name=" + this.name + "}";
    }

    public StructureAttachments getAttachments() {
        return this.attachments;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public SlotGrid getGrid() {
        return this.grid;
    }

    public void setGrid(SlotGrid grid) {
        this.grid = grid;
    }
}

