/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.structure.attachment;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.piece.StructurePieceSetupMetadata;
import io.ticticboom.mods.mm.structure.attachment.MMStructureAttachmentRegistry;
import io.ticticboom.mods.mm.structure.attachment.StructureAttachment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class StructureAttachments {
    public final Map<ResourceLocation, StructureAttachment> attachments = new HashMap<ResourceLocation, StructureAttachment>();

    public static StructureAttachments parse(JsonObject json) {
        List<StructureAttachment> attachments = MMStructureAttachmentRegistry.parseStructureAttachments(json);
        return new StructureAttachments(attachments);
    }

    public StructureAttachments(List<StructureAttachment> attachments) {
        this.attachments.putAll(attachments.stream().collect(Collectors.toMap(StructureAttachment::getId, a -> a)));
    }

    public boolean has(ResourceLocation id) {
        return this.attachments.containsKey(id);
    }

    public <T extends StructureAttachment> T get(ResourceLocation id, Class<T> clazz) {
        return (T)this.attachments.get(id);
    }

    public void validate(StructurePieceSetupMetadata meta) {
        for (Map.Entry<ResourceLocation, StructureAttachment> entry : this.attachments.entrySet()) {
            entry.getValue().validate(meta);
        }
    }
}

