/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.structure.attachment.states;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.structure.attachment.states.NamedStateList;
import java.util.HashMap;
import java.util.Map;

public record StateLists(Map<String, NamedStateList> states) {
    public NamedStateList get(String name) {
        return this.states.get(name);
    }

    public boolean has(String name) {
        return this.states.containsKey(name);
    }

    public static StateLists parse(JsonObject states) {
        HashMap<String, NamedStateList> map = new HashMap<String, NamedStateList>();
        for (Map.Entry entry : states.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException(String.format("State list %s must be an object", entry.getKey()));
            }
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            NamedStateList stateList = NamedStateList.parse((String)entry.getKey(), obj);
            map.put((String)entry.getKey(), stateList);
        }
        return new StateLists(map);
    }
}

