/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.structure.layout;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.ticticboom.mods.mm.structure.layout.StructureKeyChar;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.apache.logging.log4j.util.TriConsumer;

public class StructureCharacterGrid {
    private List<List<String>> rawLayout;
    private Vec3i bounds;
    private BlockPos controllerPos;

    public StructureCharacterGrid(List<List<String>> rawLayout) {
        this.rawLayout = rawLayout;
        this.calculateBounds();
    }

    public void calculateBounds() {
        int ySize = 0;
        int zSize = 0;
        int xSize = 0;
        int invertedY = 0;
        int y = this.rawLayout.size() - 1;
        while (y >= 0) {
            List<String> layer = this.rawLayout.get(y);
            int z = 0;
            while (z < layer.size()) {
                String row = layer.get(z);
                int x = 0;
                while (x < row.length()) {
                    if (row.charAt(x) == 'C') {
                        this.controllerPos = new BlockPos(x, invertedY, z);
                    }
                    xSize = x++;
                }
                zSize = z++;
            }
            ++invertedY;
            ySize = y--;
        }
        this.bounds = new Vec3i(xSize, ySize, zSize);
    }

    public void runFor(TriConsumer<BlockPos, BlockPos, StructureKeyChar> consumer) {
        int invertedY = 0;
        for (int y = this.rawLayout.size() - 1; y >= 0; --y) {
            List<String> layer = this.rawLayout.get(y);
            for (int z = 0; z < layer.size(); ++z) {
                String row = layer.get(z);
                for (int x = 0; x < row.length(); ++x) {
                    char chr = row.charAt(x);
                    if (chr == ' ' || chr == 'C') continue;
                    consumer.accept((Object)new BlockPos(x, invertedY, z), (Object)this.controllerPos, (Object)new StructureKeyChar(chr));
                }
            }
            ++invertedY;
        }
    }

    public char getValueAt(int x, int y, int z) {
        return this.rawLayout.get(y).get(z).charAt(x);
    }

    public char getValueAt(BlockPos pos) {
        return this.getValueAt(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public JsonArray serialize() {
        JsonArray result = new JsonArray();
        for (List<String> layer : this.rawLayout) {
            JsonArray layerJson = new JsonArray();
            for (String row : layer) {
                layerJson.add(row);
            }
            result.add((JsonElement)layerJson);
        }
        return result;
    }

    public Vec3i getBounds() {
        return this.bounds;
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }
}

