/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ParserUtils {
    public static ResourceLocation parseId(JsonElement json) {
        return new ResourceLocation(json.getAsString());
    }

    public static ResourceLocation parseId(JsonObject json, String key) {
        return ParserUtils.parseId(json.get(key));
    }

    public static Component parseComponent(JsonElement json) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            return Component.m_237113_((String)json.getAsString());
        }
        if (json.isJsonObject() && json.getAsJsonObject().has("translation")) {
            return Component.m_237115_((String)json.getAsJsonObject().get("translation").getAsString());
        }
        throw new RuntimeException("Failed to parse text component as literal or translatable, Refer to MM documentation for assistance");
    }

    public static Component parseComponent(JsonObject json, String key) {
        return ParserUtils.parseComponent(json.get(key));
    }

    public static <T> T parseOrDefault(JsonObject json, String key, Supplier<T> defaultSupplier, Function<JsonObject, T> parser) {
        if (json.has(key)) {
            return parser.apply(json);
        }
        return defaultSupplier.get();
    }

    public static <T> Supplier<T> parseOrDefaultSupplier(JsonObject json, String key, Supplier<T> defaultSupplier, Function<JsonElement, T> getter) {
        Supplier<Object> autoPushSupplier = defaultSupplier;
        if (json.has(key)) {
            Object autoPush = getter.apply(json.get(key));
            autoPushSupplier = () -> autoPush;
        }
        return autoPushSupplier;
    }

    public static <T extends Enum<T>> T parseEnum(JsonObject json, String key, Class<T> cls) {
        String name = json.get(key).getAsString();
        return Enum.valueOf(cls, name.toUpperCase());
    }
}

