/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.structure;

import io.ticticboom.mods.mm.client.structure.GuiBlockRenderer;
import io.ticticboom.mods.mm.piece.modifier.StructurePieceModifier;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;

public class GuiStructureLayoutPiece {
    private final Supplier<List<Block>> blocks;
    private final Component display;
    private final List<StructurePieceModifier> modifiers;

    public GuiStructureLayoutPiece(Supplier<List<Block>> blocks, Component display, List<StructurePieceModifier> modifiers) {
        this.blocks = blocks;
        this.display = display;
        this.modifiers = modifiers;
    }

    public List<GuiBlockRenderer> createBlockRenderer(BlockPos pos) {
        return this.blocks.get().stream().map(b -> {
            GuiBlockRenderer res = new GuiBlockRenderer((Block)b, this.modifiers);
            res.setupAt(pos);
            return res;
        }).toList();
    }

    public List<Block> getBlocks() {
        return this.blocks.get();
    }

    public Component getDisplay() {
        return this.display;
    }
}

