/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.structure;

import io.ticticboom.mods.mm.client.structure.AutoTransform;
import io.ticticboom.mods.mm.client.structure.GuiBlockRenderer;
import io.ticticboom.mods.mm.client.structure.GuiStructureLayout;
import io.ticticboom.mods.mm.client.structure.PositionedCyclingBlockRenderer;
import io.ticticboom.mods.mm.client.structure.TickCycling;
import io.ticticboom.mods.mm.structure.StructureManager;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;

public class GuiStructureRenderer {
    public static boolean shouldEnsureValidated = false;
    private final StructureModel model;
    private List<PositionedCyclingBlockRenderer> parts;
    private final GuiStructureLayout guiLayout;
    private AutoTransform mouseTransform;
    private boolean isInitialized = false;

    public GuiStructureRenderer(StructureModel model) {
        this.model = model;
        this.mouseTransform = new AutoTransform(model);
        this.guiLayout = new GuiStructureLayout(model.layout());
        this.parts = new ArrayList<PositionedCyclingBlockRenderer>();
    }

    public void init() {
        if (!this.isInitialized) {
            this.model.layout().setup(this.model.id());
            this.parts = this.guiLayout.createBlockRenderers();
            this.parts.add(this.model.controllerUiRenderer());
            for (PositionedCyclingBlockRenderer part : this.parts) {
                ((TickCycling)part.part).setInterval(60);
            }
            this.isInitialized = true;
        }
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY) {
        if (shouldEnsureValidated) {
            StructureManager.validateAllPieces();
            shouldEnsureValidated = false;
        }
        this.mouseTransform.run(mouseX, mouseY);
        for (PositionedCyclingBlockRenderer part : this.parts) {
            ((TickCycling)part.part).tick();
            GuiBlockRenderer next = (GuiBlockRenderer)((TickCycling)part.part).next();
            next.render(gfx, mouseX, mouseY, this.mouseTransform);
        }
    }

    public void resetTransforms() {
        this.mouseTransform.reset();
    }
}

