/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat.jei.category;

import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.compat.jei.SlotGridEntry;
import io.ticticboom.mods.mm.item.BlueprintItem;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.recipe.input.IRecipeIngredientEntry;
import io.ticticboom.mods.mm.recipe.output.IRecipeOutputEntry;
import io.ticticboom.mods.mm.setup.MMRegisters;
import io.ticticboom.mods.mm.structure.StructureModel;
import io.ticticboom.mods.mm.util.WidgetUtils;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MMRecipeCategory
implements IRecipeCategory<RecipeModel> {
    public static final RecipeType<RecipeModel> RECIPE_TYPE = RecipeType.create((String)"mm", (String)"recipes", RecipeModel.class);
    private final IJeiHelpers helpers;
    private final IDrawable bgProgressBar;
    private final StructureModel structureModel;
    private final IDrawable fgProgressBar;
    private final RecipeType<RecipeModel> recipeType;

    public ResourceLocation getRegistryName(RecipeModel recipe) {
        return recipe.id();
    }

    public MMRecipeCategory(IJeiHelpers helpers, StructureModel parent) {
        this.helpers = helpers;
        this.bgProgressBar = helpers.getGuiHelper().createDrawable(Ref.Textures.SLOT_PARTS, 26, 0, 24, 17);
        this.structureModel = parent;
        IDrawableStatic staticProgressBar = helpers.getGuiHelper().createDrawable(Ref.Textures.SLOT_PARTS, 26, 17, 24, 17);
        this.fgProgressBar = helpers.getGuiHelper().createAnimatedDrawable(staticProgressBar, 16, IDrawableAnimated.StartDirection.LEFT, false);
        this.recipeType = this.structureModel != null ? RecipeType.create((String)"mm", (String)(parent.id().m_135815_() + "_recipe"), RecipeModel.class) : RECIPE_TYPE;
    }

    public RecipeType<RecipeModel> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        if (this.structureModel != null) {
            return Component.m_237113_((String)this.structureModel.name()).m_7220_((Component)Component.m_237113_((String)" (Recipes)"));
        }
        return Component.m_237113_((String)"MM Recipes");
    }

    public IDrawable getBackground() {
        return this.helpers.getGuiHelper().createBlankDrawable(162, 50);
    }

    public IDrawable getIcon() {
        return this.helpers.getGuiHelper().createDrawableItemStack(((BlueprintItem)((Object)MMRegisters.BLUEPRINT.get())).m_7968_());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeModel recipe, IFocusGroup focuses) {
        SlotGrid inGrid = new SlotGrid(20, 20, 3, 5, 0, 0);
        SlotGrid outGrid = new SlotGrid(20, 20, 3, 5, 100, 0);
        for (IRecipeIngredientEntry input : recipe.inputs().inputs()) {
            input.setRecipe(builder, recipe, focuses, this.helpers, inGrid);
        }
        for (IRecipeOutputEntry output : recipe.outputs().outputs()) {
            output.setRecipe(builder, recipe, focuses, this.helpers, outGrid);
        }
        recipe.inputSlots().addAll(inGrid.getSlots());
        recipe.inputSlots().addAll(outGrid.getSlots());
    }

    public void draw(RecipeModel recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gfx, double mouseX, double mouseY) {
        this.bgProgressBar.draw(gfx, 70, 12);
        this.fgProgressBar.draw(gfx, 70, 12);
        double seconds = (double)recipe.ticks() / 20.0;
        String fmt = String.format("%.2f", seconds) + "s";
        if (WidgetUtils.isPointerWithinSized((int)mouseX, (int)mouseY, 70, 12, 24, 17)) {
            gfx.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)fmt), (int)mouseX, (int)mouseY);
        }
        if (this.structureModel == null) {
            gfx.m_280218_(Ref.Textures.SLOT_PARTS, 75, 28, 19, 26, 7, 9);
            if (WidgetUtils.isPointerWithinSized((int)mouseX, (int)mouseY, 75, 28, 7, 9)) {
                gfx.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)("Structure: " + recipe.structureId().toString())), (int)mouseX, (int)mouseY);
            }
        }
        for (SlotGridEntry inputSlot : recipe.inputSlots()) {
            if (!inputSlot.used()) continue;
            gfx.m_280218_(Ref.Textures.SLOT_PARTS, inputSlot.x, inputSlot.y, 0, 26, 18, 18);
        }
    }

    public StructureModel getStructureModel() {
        return this.structureModel;
    }
}

