/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat.jei.category;

import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.client.structure.GuiCountedItemStack;
import io.ticticboom.mods.mm.client.structure.GuiStructureRenderer;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.compat.jei.SlotGridEntry;
import io.ticticboom.mods.mm.controller.MMControllerRegistry;
import io.ticticboom.mods.mm.item.BlueprintItem;
import io.ticticboom.mods.mm.setup.MMRegisters;
import io.ticticboom.mods.mm.structure.StructureModel;
import io.ticticboom.mods.mm.util.GLScissor;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class MMStructureCategory
implements IRecipeCategory<StructureModel> {
    public static final RecipeType<StructureModel> RECIPE_TYPE = RecipeType.create((String)"mm", (String)"structure", StructureModel.class);
    private final IGuiHelper helper;
    private Vector3f pan = new Vector3f(0.0f, 0.0f, 0.0f);

    public MMStructureCategory(IGuiHelper helper) {
        this.helper = helper;
    }

    public RecipeType<StructureModel> getRecipeType() {
        return RECIPE_TYPE;
    }

    public ResourceLocation getRegistryName(StructureModel recipe) {
        return recipe.id();
    }

    public Component getTitle() {
        return Component.m_237113_((String)"MM Structure");
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(Ref.Textures.GUI_LARGE_JEI, 0, 0, 162, 170);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableItemStack(((BlueprintItem)((Object)MMRegisters.BLUEPRINT.get())).m_7968_());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StructureModel recipe, IFocusGroup focuses) {
        IIngredientAcceptor catalysts = builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST);
        for (ResourceLocation id : recipe.controllerIds().getIds()) {
            Item controller = MMControllerRegistry.getControllerItem(id);
            if (controller == null) continue;
            catalysts.addItemStack(controller.m_7968_());
        }
        GuiStructureRenderer guiRenderer = recipe.getGuiRenderer();
        guiRenderer.resetTransforms();
        guiRenderer.init();
        List<GuiCountedItemStack> countedItemStacks = recipe.getCountedItemStacks();
        SlotGrid grid = new SlotGrid(20, 20, 8, 3, 1, 130);
        recipe.setGrid(grid);
        for (GuiCountedItemStack countedItemStack : countedItemStacks) {
            SlotGridEntry next = grid.next();
            next.setUsed();
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, next.x, next.y);
            slot.addItemStacks(countedItemStack.getStacks());
            slot.addTooltipCallback((a, b) -> {
                int size = b.size();
                int insertIndex = size >= 2 ? size - 2 : size;
                b.add(insertIndex, countedItemStack.getDetail());
            });
        }
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStack(((BlueprintItem)((Object)MMRegisters.BLUEPRINT.get())).getStructureInstance(recipe.id()));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(((BlueprintItem)((Object)MMRegisters.BLUEPRINT.get())).getStructureInstance(recipe.id()));
    }

    public void draw(StructureModel recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Vector4f zero = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        zero.mul((Matrix4fc)guiGraphics.m_280168_().m_85850_().m_252922_());
        GLScissor.enable((int)zero.x(), (int)zero.y(), 160, 120);
        GuiStructureRenderer renderer = recipe.getGuiRenderer();
        renderer.render(guiGraphics, (int)mouseX, (int)mouseY);
        GLScissor.disable();
        for (SlotGridEntry slot : recipe.getGrid().getSlots()) {
            if (!slot.used()) continue;
            guiGraphics.m_280218_(Ref.Textures.SLOT_PARTS, slot.x - 1, slot.y - 1, 0, 26, 18, 18);
        }
        FormattedText fText = FormattedText.m_130775_((String)recipe.name());
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
        guiGraphics.m_280554_(Minecraft.m_91087_().f_91062_, fText, 5, 5, 160, 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
    }
}

