/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.controller.machine.register;

import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.controller.IControllerBlockEntity;
import io.ticticboom.mods.mm.controller.IControllerPart;
import io.ticticboom.mods.mm.controller.machine.register.MachineControllerMenu;
import io.ticticboom.mods.mm.model.ControllerModel;
import io.ticticboom.mods.mm.recipe.MachineRecipeManager;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import io.ticticboom.mods.mm.structure.StructureManager;
import io.ticticboom.mods.mm.structure.StructureModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MachineControllerBlockEntity
extends BlockEntity
implements IControllerBlockEntity,
IControllerPart {
    private final ControllerModel model;
    private final RegistryGroupHolder groupHolder;
    private final ResourceLocation controllerId;
    private StructureModel structure = null;
    private RecipeStateModel recipeState = null;
    private RecipeModel currentRecipe = null;
    private RecipeStorages portStorages = null;

    public MachineControllerBlockEntity(ControllerModel model, RegistryGroupHolder groupHolder, BlockPos pos, BlockState state) {
        super((BlockEntityType)groupHolder.getBe().get(), pos, state);
        this.model = model;
        this.groupHolder = groupHolder;
        this.controllerId = Ref.id(model.id());
    }

    public void tick() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.runMachineTick();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    private void runMachineTick() {
        if (this.canRemainFormed()) {
            this.runRecipe();
            return;
        }
        for (StructureModel structureModel : StructureManager.STRUCTURES.values()) {
            if (!structureModel.controllerIds().contains(this.controllerId) || !structureModel.formed(this.f_58857_, this.m_58899_())) continue;
            this.m_6596_();
            this.structure = structureModel;
            this.runRecipe();
            return;
        }
        this.invalidateProgress();
    }

    private boolean canRemainFormed() {
        if (this.structure == null) {
            return false;
        }
        return this.structure.formed(this.f_58857_, this.m_58899_());
    }

    private boolean canContinueRecipe() {
        if (this.currentRecipe == null) {
            return false;
        }
        return this.currentRecipe.canProcess(this.f_58857_, this.recipeState, this.portStorages);
    }

    private void runRecipe() {
        if (this.portStorages == null) {
            this.portStorages = this.structure.getStorages(this.f_58857_, this.m_58899_());
        }
        if (this.recipeState == null) {
            this.recipeState = new RecipeStateModel();
        }
        if (!this.canContinueRecipe()) {
            for (RecipeModel recipe : MachineRecipeManager.RECIPES.values()) {
                if (!recipe.structureId().equals((Object)this.structure.id()) || !recipe.canProcess(this.f_58857_, this.recipeState, this.portStorages)) continue;
                this.m_6596_();
                this.currentRecipe = recipe;
                this.performRecipeTick();
                return;
            }
            this.invalidateRecipe(false);
            return;
        }
        this.performRecipeTick();
    }

    private void performRecipeTick() {
        this.currentRecipe.runTick(this.f_58857_, this.recipeState, this.portStorages);
        if (this.recipeState.isCanFinish()) {
            this.currentRecipe.process(this.f_58857_, this.recipeState, this.portStorages);
            this.invalidateRecipe(true);
        }
    }

    public void invalidateProgress() {
        this.m_6596_();
        this.structure = null;
        this.invalidateRecipe(false);
    }

    public void invalidateRecipe(boolean typical) {
        if (this.currentRecipe != null && !typical && this.portStorages != null) {
            this.currentRecipe.ditchRecipe(this.f_58857_, this.recipeState, this.portStorages);
        }
        this.portStorages = null;
        this.recipeState = null;
        this.currentRecipe = null;
    }

    @Override
    public ControllerModel getModel() {
        return this.model;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)this.model.name());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new MachineControllerMenu(this.model, this.groupHolder, windowId, inv, this);
    }

    protected void m_183515_(CompoundTag tag) {
        if (this.recipeState != null) {
            tag.m_128365_("recipeState", (Tag)this.recipeState.save(new CompoundTag()));
        }
        if (this.structure != null) {
            tag.m_128359_("structureId", this.structure.id().toString());
        }
        if (this.currentRecipe != null) {
            tag.m_128359_("recipeId", this.currentRecipe.id().toString());
        }
        tag.m_128379_("filler", true);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.recipeState = tag.m_128441_("recipeState") ? RecipeStateModel.load(tag.m_128469_("recipeState")) : null;
        if (tag.m_128441_("structureId")) {
            ResourceLocation structureId = new ResourceLocation(tag.m_128423_("structureId").m_7916_());
            this.structure = StructureManager.STRUCTURES.get(structureId);
        } else {
            this.structure = null;
        }
        if (tag.m_128441_("recipeId")) {
            ResourceLocation recipeId = new ResourceLocation(tag.m_128423_("recipeId").m_7916_());
            this.currentRecipe = MachineRecipeManager.RECIPES.get(recipeId);
        } else {
            this.currentRecipe = null;
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public StructureModel getStructure() {
        return this.structure;
    }

    public RecipeStateModel getRecipeState() {
        return this.recipeState;
    }
}

