/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.datagen;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public class GeneratedPack
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final String packId;
    private final boolean isBuiltin;
    private final Path root;

    public GeneratedPack(String packId, boolean isBuiltin, Path source) {
        this.packId = packId;
        this.isBuiltin = isBuiltin;
        this.root = source;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        JsonObject jsonobject = new JsonObject();
        JsonObject packObject = new JsonObject();
        packObject.addProperty("pack_format", (Number)15);
        packObject.addProperty("description", "mm");
        jsonobject.add("pack", (JsonElement)packObject);
        if (!jsonobject.has(deserializer.m_7991_())) {
            return null;
        }
        try {
            return (T)deserializer.m_6322_(GsonHelper.m_13930_((JsonObject)jsonobject, (String)deserializer.m_7991_()));
        }
        catch (JsonParseException jsonparseexception) {
            return null;
        }
    }

    public String m_5542_() {
        return this.packId;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... p_249041_) {
        FileUtil.m_245411_((String[])p_249041_);
        Path path = FileUtil.m_245247_((Path)this.root, List.of(p_249041_));
        return Files.exists(path, new LinkOption[0]) ? IoSupplier.m_246697_((Path)path) : null;
    }

    public static boolean validatePath(Path p_249579_) {
        return true;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType p_249352_, ResourceLocation p_251715_) {
        Path path = this.root.resolve(p_249352_.m_10305_()).resolve(p_251715_.m_135827_());
        return GeneratedPack.getResource(p_251715_, path);
    }

    public static IoSupplier<InputStream> getResource(ResourceLocation p_250145_, Path p_251046_) {
        return (IoSupplier)FileUtil.m_245538_((String)p_250145_.m_135815_()).get().map(p_251647_ -> {
            Path path = FileUtil.m_245247_((Path)p_251046_, (List)p_251647_);
            return GeneratedPack.returnFileIfExists(path);
        }, p_248714_ -> {
            LOGGER.error("Invalid path {}: {}", (Object)p_250145_, (Object)p_248714_.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> returnFileIfExists(Path p_250506_) {
        return Files.exists(p_250506_, new LinkOption[0]) && GeneratedPack.validatePath(p_250506_) ? IoSupplier.m_246697_((Path)p_250506_) : null;
    }

    public void m_8031_(PackType p_251452_, String p_249854_, String p_248650_, PackResources.ResourceOutput p_248572_) {
        FileUtil.m_245538_((String)p_248650_).get().ifLeft(p_250225_ -> {
            Path path = this.root.resolve(p_251452_.m_10305_()).resolve(p_249854_);
            GeneratedPack.listPath(p_249854_, path, p_250225_, p_248572_);
        }).ifRight(p_252338_ -> LOGGER.error("Invalid path {}: {}", (Object)p_248650_, (Object)p_252338_.message()));
    }

    public static void listPath(String p_249455_, Path p_249514_, List<String> p_251918_, PackResources.ResourceOutput p_249964_) {
        Path path = FileUtil.m_245247_((Path)p_249514_, p_251918_);
        try (Stream<Path> stream2 = Files.find(path, Integer.MAX_VALUE, (p_250060_, p_250796_) -> p_250796_.isRegularFile(), new FileVisitOption[0]);){
            stream2.forEach(p_249092_ -> {
                String s = PATH_JOINER.join((Iterable)p_249514_.relativize((Path)p_249092_));
                ResourceLocation resourcelocation = ResourceLocation.m_214293_((String)p_249455_, (String)s);
                if (resourcelocation == null) {
                    Util.m_143785_((String)String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", p_249455_, s));
                } else {
                    p_249964_.accept((Object)resourcelocation, (Object)IoSupplier.m_246697_((Path)p_249092_));
                }
            });
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to list path {}", (Object)path, (Object)ioexception);
        }
    }

    public Set<String> m_5698_(PackType p_251896_) {
        HashSet set = Sets.newHashSet();
        Path path = this.root.resolve(p_251896_.m_10305_());
        try (DirectoryStream<Path> directorystream2 = Files.newDirectoryStream(path);){
            for (Path path1 : directorystream2) {
                String s = path1.getFileName().toString();
                if (s.equals(s.toLowerCase(Locale.ROOT))) {
                    set.add(s);
                    continue;
                }
                LOGGER.warn("Ignored non-lowercase namespace: {} in {}", (Object)s, (Object)this.root);
            }
        }
        catch (NoSuchFileException directorystream2) {
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to list path {}", (Object)path, (Object)ioexception);
        }
        return set;
    }

    public void close() {
    }
}

