/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.debug.output;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.model.ControllerModel;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class CollectedDebugData {
    public List<StructureModel> structureDefs = new ArrayList<StructureModel>();
    public List<RecipeModel> recipeDefs = new ArrayList<RecipeModel>();
    public List<PortModel> portDefs = new ArrayList<PortModel>();
    public ControllerModel controllerDef;
    public List<JsonObject> structureStates = new ArrayList<JsonObject>();
    public List<JsonObject> recipeStates = new ArrayList<JsonObject>();
    public JsonObject diags = new JsonObject();

    public void addRecipe(RecipeModel recipe) {
        if (this.recipeDefs == null) {
            this.recipeDefs = new ArrayList<RecipeModel>();
        }
        this.recipeDefs.add(recipe);
    }

    public void addStructure(StructureModel structure) {
        if (structure == null) {
            this.structureDefs = new ArrayList<StructureModel>();
        }
        this.structureDefs.add(structure);
    }

    public void addStructureState(JsonObject state) {
        if (state == null) {
            this.structureStates = new ArrayList<JsonObject>();
        }
        this.structureStates.add(state);
    }

    public void addRecipeState(JsonObject state) {
        if (state == null) {
            this.recipeStates = new ArrayList<JsonObject>();
        }
        this.recipeStates.add(state);
    }

    public List<ResourceLocation> getStructureIds() {
        return this.structureDefs.stream().map(StructureModel::id).toList();
    }

    public List<StructureModel> getStructureDefs() {
        return this.structureDefs;
    }

    public List<RecipeModel> getRecipeDefs() {
        return this.recipeDefs;
    }

    public List<PortModel> getPortDefs() {
        return this.portDefs;
    }

    public ControllerModel getControllerDef() {
        return this.controllerDef;
    }

    public List<JsonObject> getStructureStates() {
        return this.structureStates;
    }

    public List<JsonObject> getRecipeStates() {
        return this.recipeStates;
    }

    public JsonObject getDiags() {
        return this.diags;
    }

    public void setStructureDefs(List<StructureModel> structureDefs) {
        this.structureDefs = structureDefs;
    }

    public void setRecipeDefs(List<RecipeModel> recipeDefs) {
        this.recipeDefs = recipeDefs;
    }

    public void setPortDefs(List<PortModel> portDefs) {
        this.portDefs = portDefs;
    }

    public void setControllerDef(ControllerModel controllerDef) {
        this.controllerDef = controllerDef;
    }

    public void setStructureStates(List<JsonObject> structureStates) {
        this.structureStates = structureStates;
    }

    public void setRecipeStates(List<JsonObject> recipeStates) {
        this.recipeStates = recipeStates;
    }

    public void setDiags(JsonObject diags) {
        this.diags = diags;
    }
}

