/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.model.IdList;
import io.ticticboom.mods.mm.port.IPortStorageFactory;
import io.ticticboom.mods.mm.port.MMPortRegistry;
import io.ticticboom.mods.mm.port.PortType;
import io.ticticboom.mods.mm.util.ParserUtils;
import io.ticticboom.mods.mm.util.PortUtils;
import net.minecraft.resources.ResourceLocation;

public record PortModel(String id, String name, IdList controllerIds, ResourceLocation type, IPortStorageFactory config, JsonObject jsonConfig, boolean input) {
    public static PortModel parse(JsonObject json, boolean input) {
        String id = PortUtils.id(json.get("id").getAsString(), input);
        String name = PortUtils.name(json.get("name").getAsString(), input);
        IdList controllerIds = IdList.parse(json.get("controllerIds"));
        ResourceLocation type = ParserUtils.parseId(json, "type");
        PortType portType = MMPortRegistry.get(type);
        IPortStorageFactory storageFactory = portType.getParser().parseStorage(json.get("config").getAsJsonObject());
        return new PortModel(id, name, controllerIds, type, storageFactory, json, input);
    }

    public static PortModel create(String id, String name, IdList controllerIds, ResourceLocation type, IPortStorageFactory config, boolean input) {
        String fid = PortUtils.id(id, input);
        String fname = PortUtils.name(name, input);
        JsonObject json = PortModel.paramsToJson(fid, fname, controllerIds, type, config, input);
        return new PortModel(fid, fname, controllerIds, type, config, json, input);
    }

    public static JsonObject paramsToJson(String id, String name, IdList controllerIds, ResourceLocation type, IPortStorageFactory config, boolean input) {
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        json.addProperty("name", name);
        json.add("controllerIds", (JsonElement)controllerIds.serialize());
        json.addProperty("type", type.toString());
        json.addProperty("config", config.toString());
        return json;
    }
}

