/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.energy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.compat.jei.ingredient.MMJeiIngredients;
import io.ticticboom.mods.mm.compat.jei.ingredient.energy.EnergyStack;
import io.ticticboom.mods.mm.port.IPortIngredient;
import io.ticticboom.mods.mm.port.energy.EnergyPortStorage;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.world.level.Level;

public class EnergyPortIngredient
implements IPortIngredient {
    private final int amount;

    public EnergyPortIngredient(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean canProcess(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<EnergyPortStorage> inputStorages = storages.getInputStorages(EnergyPortStorage.class);
        int remaining = this.amount;
        for (EnergyPortStorage storage : inputStorages) {
            int extracted = storage.internalExtract(remaining, true);
            remaining -= extracted;
        }
        return remaining <= 0;
    }

    @Override
    public void process(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<EnergyPortStorage> inputStorages = storages.getInputStorages(EnergyPortStorage.class);
        int remaining = this.amount;
        for (EnergyPortStorage storage : inputStorages) {
            int extracted = storage.internalExtract(remaining, false);
            remaining -= extracted;
        }
    }

    @Override
    public boolean canOutput(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<EnergyPortStorage> outputStorages = storages.getOutputStorages(EnergyPortStorage.class);
        int remaining = this.amount;
        for (EnergyPortStorage storage : outputStorages) {
            int inserted = storage.internalInsert(remaining, true);
            remaining -= inserted;
        }
        return remaining <= 0;
    }

    @Override
    public void output(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<EnergyPortStorage> outputStorages = storages.getOutputStorages(EnergyPortStorage.class);
        int remaining = this.amount;
        for (EnergyPortStorage storage : outputStorages) {
            int inserted = storage.internalInsert(remaining, false);
            remaining -= inserted;
        }
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeModel model, IFocusGroup focus, IJeiHelpers helpers, SlotGrid grid, IRecipeSlotBuilder recipeSlot) {
        recipeSlot.addIngredient((IIngredientType)MMJeiIngredients.ENERGY, (Object)new EnergyStack(this.amount));
    }

    @Override
    public JsonObject debugInput(Level level, RecipeStorages storages, JsonObject json) {
        List<EnergyPortStorage> inputStorages = storages.getInputStorages(EnergyPortStorage.class);
        JsonArray searchedStoragesJson = new JsonArray();
        JsonArray searchIterationsJson = new JsonArray();
        json.addProperty("ingredientType", Ref.Ports.ENERGY.toString());
        json.addProperty("amountToExtract", (Number)this.amount);
        int remaining = this.amount;
        for (EnergyPortStorage storage : inputStorages) {
            JsonObject iterJson = new JsonObject();
            int extracted = storage.internalExtract(remaining, true);
            iterJson.addProperty("extracted", (Number)extracted);
            iterJson.addProperty("remainingToExtract", (Number)(remaining -= extracted));
            iterJson.addProperty("storageUid", storage.getStorageUid().toString());
            searchIterationsJson.add((JsonElement)iterJson);
            searchedStoragesJson.add(storage.getStorageUid().toString());
        }
        json.add("extractIterations", (JsonElement)searchIterationsJson);
        json.addProperty("canRun", Boolean.valueOf(remaining <= 0));
        json.add("searchedStorages", (JsonElement)searchedStoragesJson);
        return json;
    }

    @Override
    public JsonObject debugOutput(Level level, RecipeStorages storages, JsonObject json) {
        List<EnergyPortStorage> outputStorages = storages.getOutputStorages(EnergyPortStorage.class);
        JsonArray searchedStoragesJson = new JsonArray();
        JsonArray searchIterationsJson = new JsonArray();
        json.addProperty("ingredientType", Ref.Ports.ENERGY.toString());
        json.addProperty("amountToInsert", (Number)this.amount);
        int remaining = this.amount;
        for (EnergyPortStorage storage : outputStorages) {
            JsonObject iterJson = new JsonObject();
            int inserted = storage.internalInsert(remaining, true);
            iterJson.addProperty("inserted", (Number)inserted);
            iterJson.addProperty("remainingToInsert", (Number)(remaining -= inserted));
            searchIterationsJson.add((JsonElement)iterJson);
            searchedStoragesJson.add(storage.getStorageUid().toString());
        }
        json.add("insertIterations", (JsonElement)searchIterationsJson);
        json.addProperty("canRun", Boolean.valueOf(remaining <= 0));
        json.add("searchedStorages", (JsonElement)searchedStoragesJson);
        return json;
    }
}

