/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.energy.feature;

import io.ticticboom.mods.mm.cap.MMCapabilities;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortBlockEntity;
import io.ticticboom.mods.mm.port.common.AbstractPortAutoPushFeature;
import io.ticticboom.mods.mm.port.energy.feature.EnergyHandlerCoupling;
import io.ticticboom.mods.mm.port.energy.register.EnergyPortBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyPortAutoPushFeature
extends AbstractPortAutoPushFeature<EnergyHandlerCoupling> {
    public EnergyPortAutoPushFeature(EnergyPortBlockEntity portBlockEntity, PortModel model) {
        super(portBlockEntity, model);
    }

    @Override
    public void tick() {
        Level level = this.portBlockEntity.m_58904_();
        if (level == null) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        for (EnergyHandlerCoupling cap : this.autoPushNeighbors.values()) {
            cap.attemptTransfer();
        }
    }

    @Override
    protected void tryAddNeighborHandler(BlockPos neighborPos, Direction neighborFace) {
        BlockEntity neighborBe = this.portBlockEntity.m_58904_().m_7702_(neighborPos);
        if (neighborBe == null) {
            return;
        }
        boolean valid = this.canAddAsNeighbor(neighborPos, neighborBe);
        if (!valid) {
            return;
        }
        LazyOptional neighborCap = neighborBe.getCapability(MMCapabilities.ENERGY, neighborFace);
        if (!neighborCap.isPresent()) {
            return;
        }
        if (this.autoPushNeighbors.containsKey(neighborPos)) {
            EnergyHandlerCoupling pairing = (EnergyHandlerCoupling)this.autoPushNeighbors.get(neighborPos);
            pairing.setToHandler((LazyOptional<IEnergyStorage>)neighborCap);
        } else {
            LazyOptional capability = this.portBlockEntity.getCapability(MMCapabilities.ENERGY);
            this.autoPushNeighbors.put(neighborPos, new EnergyHandlerCoupling((LazyOptional<IEnergyStorage>)capability, (LazyOptional<IEnergyStorage>)neighborCap));
        }
    }

    private boolean canAddAsNeighbor(BlockPos pos, BlockEntity be) {
        if (be instanceof IPortBlockEntity) {
            IPortBlockEntity pbe = (IPortBlockEntity)be;
            return pbe.isInput();
        }
        return true;
    }
}

