/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.fluid;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FluidPortHandler
implements IFluidHandler {
    private final int tanks;
    private final int capacity;
    private final INotifyChangeFunction changed;
    private final ArrayList<FluidStack> stacks;
    public static final Codec<List<FluidStack>> STACKS_CODEC = Codec.list((Codec)FluidStack.CODEC);

    public FluidPortHandler(int tanks, int capacity, INotifyChangeFunction changed) {
        this.tanks = tanks;
        this.capacity = capacity;
        this.changed = changed;
        this.stacks = new ArrayList();
        for (int i = 0; i < tanks; ++i) {
            this.stacks.add(FluidStack.EMPTY);
        }
    }

    public int getTanks() {
        return this.tanks;
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        return this.stacks.get(i);
    }

    public void setFluidInTank(int i, FluidStack fluidStack) {
        this.stacks.set(i, fluidStack);
        this.changed.call();
    }

    public int getTankCapacity(int i) {
        return this.capacity;
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        FluidStack slotStack = this.stacks.get(i);
        return slotStack.isEmpty() || slotStack.isFluidEqual(fluidStack);
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        this.changed.call();
        if (stack.isEmpty()) {
            return 0;
        }
        int filled = 0;
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            filled += this.innerFill(slot, stack.getFluid(), stack.getAmount() - filled, action.simulate());
        }
        return filled;
    }

    private int innerFill(int slot, Fluid fluid, int amount, boolean simulate) {
        FluidStack slotStack = this.stacks.get(slot);
        int storedAmount = slotStack.getAmount();
        if (!this.isFluidValid(slot, new FluidStack(fluid, amount))) {
            return 0;
        }
        int canBeFilled = Math.min(this.capacity - storedAmount, amount);
        if (!simulate) {
            FluidStack stack = this.stacks.get(slot);
            if (stack.isEmpty()) {
                this.stacks.set(slot, new FluidStack(fluid, canBeFilled));
            } else {
                stack.setAmount(storedAmount + canBeFilled);
            }
        }
        return canBeFilled;
    }

    @NotNull
    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        FluidStack innerDrained;
        this.changed.call();
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drained = 0;
        for (int slot = 0; slot < this.stacks.size() && (drained += (innerDrained = this.innerDrain(slot, stack.getFluid(), stack.getAmount(), action.simulate())).getAmount()) < stack.getAmount(); ++slot) {
        }
        return new FluidStack(stack.getFluid(), drained);
    }

    public FluidStack innerDrain(int slot, Fluid fluid, int amount, boolean simulate) {
        FluidStack stack;
        FluidStack slotStack = this.stacks.get(slot);
        int storedAmount = slotStack.getAmount();
        if (!this.isFluidValid(slot, new FluidStack(fluid, amount))) {
            return FluidStack.EMPTY;
        }
        int canBeDrained = Math.min(storedAmount, amount);
        if (!simulate && !(stack = this.stacks.get(slot)).isEmpty()) {
            stack.setAmount(storedAmount - canBeDrained);
        }
        return new FluidStack(fluid, canBeDrained);
    }

    @NotNull
    public FluidStack drain(int i, IFluidHandler.FluidAction action) {
        FluidStack innerDrained;
        this.changed.call();
        Fluid fluid = this.findFirstFluid();
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        int drained = 0;
        for (int slot = 0; slot < this.stacks.size() && (drained += (innerDrained = this.innerDrain(slot, fluid, i, action.simulate())).getAmount()) < i; ++slot) {
        }
        return new FluidStack(fluid, drained);
    }

    private Fluid findFirstFluid() {
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            FluidStack stack = this.stacks.get(slot);
            if (stack.isEmpty()) continue;
            return stack.getFluid();
        }
        return null;
    }

    public Tag serializeNBT() {
        DataResult dataResult = (DataResult)NbtOps.f_128958_.withEncoder(STACKS_CODEC).apply(this.stacks);
        Tag result = (Tag)dataResult.getOrThrow(false, arg_0 -> ((Logger)Ref.LOG).error(arg_0));
        return result;
    }

    public void deserializeNBT(Tag nbt) {
        DataResult dataResult = (DataResult)NbtOps.f_128958_.withDecoder(STACKS_CODEC).apply(nbt);
        Pair result = (Pair)dataResult.getOrThrow(false, arg_0 -> ((Logger)Ref.LOG).error(arg_0));
        this.stacks.clear();
        this.stacks.addAll((Collection)result.getFirst());
    }

    public INotifyChangeFunction getChanged() {
        return this.changed;
    }
}

