/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.fluid;

import io.ticticboom.mods.mm.port.fluid.FluidPortHandler;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class WrappedFluidPortHandler
implements IFluidHandler {
    private final FluidPortHandler handler;

    public WrappedFluidPortHandler(FluidPortHandler handler) {
        this.handler = handler;
    }

    public int getTanks() {
        return this.handler.getTanks();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.handler.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.handler.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.handler.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        int filled = 0;
        for (int i = 0; i < this.handler.getTanks(); ++i) {
            FluidStack stack = this.handler.getFluidInTank(i);
            int tankCapacity = this.handler.getTankCapacity(i);
            if (stack.getAmount() >= tankCapacity) continue;
            if (stack.isEmpty()) {
                filled = Math.min(resource.getAmount(), tankCapacity);
                if (!action.execute()) break;
                this.handler.setFluidInTank(i, new FluidStack(resource.getFluid(), filled));
                break;
            }
            if (this.handler.isFluidValid(i, resource)) {
                int amountToFill = Math.min(tankCapacity - stack.getAmount(), resource.getAmount());
                if (action.execute()) {
                    this.handler.setFluidInTank(i, new FluidStack(stack.getFluid(), stack.getAmount() + amountToFill));
                }
                filled = amountToFill;
                break;
            }
            this.handler.getChanged().call();
        }
        this.handler.getChanged().call();
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drained = 0;
        FluidStack taken = FluidStack.EMPTY;
        for (int i = 0; i < this.handler.getTanks() && (drained = (taken = this.handler.innerDrain(i, resource.getFluid(), resource.getAmount(), action.simulate())).getAmount()) == 0; ++i) {
        }
        this.handler.getChanged().call();
        return new FluidStack(resource.getFluid(), drained);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack stack;
        FluidStack res = FluidStack.EMPTY;
        for (int i = 0; i < this.handler.getTanks() && (res = this.handler.innerDrain(i, (stack = this.handler.getFluidInTank(i)).getFluid(), maxDrain, action.simulate())).getAmount() == 0; ++i) {
        }
        this.handler.getChanged().call();
        return res;
    }
}

