/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.fluid.feature;

import io.ticticboom.mods.mm.cap.MMCapabilities;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortBlockEntity;
import io.ticticboom.mods.mm.port.common.AbstractPortAutoPushFeature;
import io.ticticboom.mods.mm.port.fluid.feature.FluidHandlerCoupling;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidPortAutoPushFeature
extends AbstractPortAutoPushFeature<FluidHandlerCoupling> {
    public FluidPortAutoPushFeature(BlockEntity portBlockEntity, PortModel model) {
        super(portBlockEntity, model);
    }

    @Override
    protected void tryAddNeighborHandler(BlockPos neighborPos, Direction neighborFace) {
        BlockEntity neighborBe = this.portBlockEntity.m_58904_().m_7702_(neighborPos);
        if (neighborBe == null) {
            return;
        }
        boolean valid = this.canAddAsNeighbor(neighborPos, neighborBe);
        if (!valid) {
            return;
        }
        LazyOptional neighborCap = neighborBe.getCapability(MMCapabilities.FLUID, neighborFace);
        if (!neighborCap.isPresent()) {
            return;
        }
        if (this.autoPushNeighbors.containsKey(neighborPos)) {
            FluidHandlerCoupling pairing = (FluidHandlerCoupling)this.autoPushNeighbors.get(neighborPos);
            pairing.setToHandler((LazyOptional<IFluidHandler>)neighborCap);
        } else {
            LazyOptional capability = this.portBlockEntity.getCapability(MMCapabilities.FLUID);
            this.autoPushNeighbors.put(neighborPos, new FluidHandlerCoupling((LazyOptional<IFluidHandler>)capability, (LazyOptional<IFluidHandler>)neighborCap));
        }
    }

    private boolean canAddAsNeighbor(BlockPos pos, BlockEntity be) {
        if (be instanceof IPortBlockEntity) {
            IPortBlockEntity pbe = (IPortBlockEntity)be;
            return pbe.isInput();
        }
        return true;
    }
}

