/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.port.IPortIngredient;
import io.ticticboom.mods.mm.port.item.ItemPortStorage;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class BaseItemPortIngredient
implements IPortIngredient {
    protected final int count;
    protected final Predicate<ItemStack> filter;

    public BaseItemPortIngredient(int count, Predicate<ItemStack> filter) {
        this.count = count;
        this.filter = filter;
    }

    @Override
    public boolean canProcess(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<ItemPortStorage> itemStorages = storages.getInputStorages(ItemPortStorage.class);
        int remaining = this.count;
        for (ItemPortStorage storage : itemStorages) {
            remaining = storage.canExtract(this.filter, remaining);
        }
        return remaining <= 0;
    }

    @Override
    public void process(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<ItemPortStorage> itemStorages = storages.getInputStorages(ItemPortStorage.class);
        int remaining = this.count;
        for (ItemPortStorage storage : itemStorages) {
            remaining = storage.extract(this.filter, remaining);
        }
    }

    @Override
    public JsonObject debugInput(Level level, RecipeStorages storages, JsonObject json) {
        List<ItemPortStorage> itemStorages = storages.getInputStorages(ItemPortStorage.class);
        JsonArray searchedStorages = new JsonArray();
        JsonArray searchIterations = new JsonArray();
        json.addProperty("ingredientType", Ref.Ports.ITEM.toString());
        json.addProperty("amountToExtract", (Number)this.count);
        int remaining = this.count;
        for (ItemPortStorage storage : itemStorages) {
            JsonObject iterJson = new JsonObject();
            remaining = storage.canExtract(this.filter, remaining);
            iterJson.addProperty("remaining", (Number)remaining);
            iterJson.addProperty("storageUid", storage.getStorageUid().toString());
            searchIterations.add((JsonElement)iterJson);
            searchedStorages.add(storage.getStorageUid().toString());
        }
        json.add("extractIterations", (JsonElement)searchIterations);
        json.addProperty("canRun", Boolean.valueOf(remaining <= 0));
        json.add("searchedStorages", (JsonElement)searchedStorages);
        return json;
    }
}

