/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.item;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageFactory;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import io.ticticboom.mods.mm.port.item.ItemPortStorage;
import io.ticticboom.mods.mm.port.item.ItemPortStorageModel;

public class ItemPortStorageFactory
implements IPortStorageFactory {
    private final ItemPortStorageModel model;

    public ItemPortStorageFactory(ItemPortStorageModel model) {
        this.model = model;
    }

    @Override
    public IPortStorage createPortStorage(INotifyChangeFunction changed) {
        return new ItemPortStorage(this.model, changed);
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("rows", (Number)this.model.rows());
        json.addProperty("columns", (Number)this.model.columns());
        return json;
    }

    @Override
    public IPortStorageModel getModel() {
        return this.model;
    }
}

