/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.item.register;

import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.common.AbstractPortAutoPushFeature;
import io.ticticboom.mods.mm.port.common.AbstractPortBlockEntity;
import io.ticticboom.mods.mm.port.item.ItemPortStorage;
import io.ticticboom.mods.mm.port.item.ItemPortStorageModel;
import io.ticticboom.mods.mm.port.item.feature.ItemPortAutoPushAddon;
import io.ticticboom.mods.mm.port.item.register.ItemPortMenu;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPortBlockEntity
extends AbstractPortBlockEntity {
    private final RegistryGroupHolder groupHolder;
    private final PortModel model;
    private final ItemPortStorage storage;
    private final boolean input;
    private final Optional<ItemPortAutoPushAddon> autoPushAddon;

    public ItemPortBlockEntity(RegistryGroupHolder groupHolder, PortModel model, boolean input, BlockPos pos, BlockState state) {
        super((BlockEntityType)groupHolder.getBe().get(), pos, state);
        this.groupHolder = groupHolder;
        this.model = model;
        this.storage = (ItemPortStorage)model.config().createPortStorage(this::m_6596_);
        this.input = input;
        boolean shouldAutoPush = !input && ((ItemPortStorageModel)this.storage.getStorageModel()).autoPush().get() != false;
        this.autoPushAddon = shouldAutoPush ? Optional.of(new ItemPortAutoPushAddon(this, this.model)) : Optional.empty();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.storage.getCapability(cap);
    }

    @Override
    public IPortStorage getStorage() {
        return this.storage;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Item Port");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new ItemPortMenu(this.model, this.groupHolder, this.input, i, inventory, this);
    }

    @Override
    public PortModel getModel() {
        return this.model;
    }

    public void tick() {
        this.autoPushAddon.ifPresent(AbstractPortAutoPushFeature::tick);
    }

    public void onLoad() {
        this.autoPushAddon.ifPresent(AbstractPortAutoPushFeature::onLoad);
    }

    public void neighborsChanged() {
        this.autoPushAddon.ifPresent(AbstractPortAutoPushFeature::tryAddNeighboringHandlers);
    }

    @Override
    public boolean isInput() {
        return this.input;
    }
}

