/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.kinetic;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import io.ticticboom.mods.mm.port.kinetic.CreateKineticPortStorageModel;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class CreateKineticPortStorage
implements IPortStorage {
    private final CreateKineticPortStorageModel model;
    private final INotifyChangeFunction changed;
    private final UUID uid = UUID.randomUUID();
    private boolean shouldStop = false;
    private float speed = 0.0f;

    public CreateKineticPortStorage(CreateKineticPortStorageModel model, INotifyChangeFunction changed) {
        this.model = model;
        this.changed = changed;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        return LazyOptional.empty();
    }

    @Override
    public <T> boolean hasCapability(Capability<T> capability) {
        return false;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128350_("speed", this.speed);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.speed = tag.m_128457_("speed");
    }

    @Override
    public IPortStorageModel getStorageModel() {
        return this.model;
    }

    @Override
    public UUID getStorageUid() {
        return this.uid;
    }

    @Override
    public JsonObject debugDump() {
        JsonObject json = new JsonObject();
        json.addProperty("uid", this.uid.toString());
        json.addProperty("speed", (Number)Float.valueOf(this.speed));
        return json;
    }

    public void updateSpeed(float speed) {
        if (speed != this.speed) {
            this.changed.call();
        }
        this.speed = speed;
    }

    public void stopNext() {
        this.shouldStop = true;
    }

    public float getStress() {
        return this.model.stress();
    }

    public boolean isShouldStop() {
        return this.shouldStop;
    }

    public float getSpeed() {
        return this.speed;
    }
}

