/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.kinetic;

import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortBlock;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.kinetic.CreateKineticPortStorageModel;
import java.util.function.DoubleSupplier;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;

public class MMKineticStressProviders {
    private static Pair<PortModel, CreateKineticPortStorageModel> getModel(Block block) {
        IPortBlock pb;
        IPortStorageModel storageModel;
        if (block instanceof IPortBlock && (storageModel = (pb = (IPortBlock)block).getModel().config().getModel()) instanceof CreateKineticPortStorageModel) {
            CreateKineticPortStorageModel psm = (CreateKineticPortStorageModel)storageModel;
            return Pair.of((Object)pb.getModel(), (Object)psm);
        }
        return null;
    }

    public static double getImpact(Block block) {
        Pair<PortModel, CreateKineticPortStorageModel> models = MMKineticStressProviders.getModel(block);
        if (models == null) {
            return 0.0;
        }
        return ((PortModel)models.getLeft()).input() ? (double)((CreateKineticPortStorageModel)models.getRight()).stress() : 0.0;
    }

    public static double getCapacity(Block block) {
        Pair<PortModel, CreateKineticPortStorageModel> models = MMKineticStressProviders.getModel(block);
        if (models == null) {
            return 0.0;
        }
        return !((PortModel)models.getLeft()).input() ? (double)((CreateKineticPortStorageModel)models.getRight()).stress() : 0.0;
    }

    public static DoubleSupplier impactSupplier(Block block) {
        return () -> MMKineticStressProviders.getImpact(block);
    }

    public static DoubleSupplier capacitySupplier(Block block) {
        return () -> MMKineticStressProviders.getCapacity(block);
    }
}

