/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.recipe.MachineRecipeManager;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.condition.IRecipeCondition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.Level;

public class RecipeConditions {
    private final List<IRecipeCondition> conditions;

    public RecipeConditions(List<IRecipeCondition> conditions) {
        this.conditions = conditions;
    }

    public static RecipeConditions parse(JsonArray arr) {
        ArrayList<IRecipeCondition> result = new ArrayList<IRecipeCondition>();
        for (JsonElement elem : arr) {
            JsonObject json = elem.getAsJsonObject();
            IRecipeCondition cond = MachineRecipeManager.parseCondition(json);
            result.add(cond);
        }
        return new RecipeConditions(result);
    }

    public boolean canRun(Level level, RecipeStateModel state) {
        for (IRecipeCondition condition : this.conditions) {
            if (condition.canRun(level, state)) continue;
            return false;
        }
        return true;
    }
}

