/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.recipe.MachineRecipeManager;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import io.ticticboom.mods.mm.recipe.input.IRecipeIngredientEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.Level;

public record RecipeInputs(List<IRecipeIngredientEntry> inputs) {
    public static RecipeInputs parse(JsonArray json) {
        ArrayList<IRecipeIngredientEntry> inputs = new ArrayList<IRecipeIngredientEntry>();
        for (JsonElement elem : json) {
            JsonObject entryJson = elem.getAsJsonObject();
            inputs.add(MachineRecipeManager.parseIngredientEntry(entryJson));
        }
        return new RecipeInputs(inputs);
    }

    public boolean canProcess(Level level, RecipeStorages storages, RecipeStateModel model) {
        for (IRecipeIngredientEntry input : this.inputs) {
            if (input.canProcess(level, storages, model)) continue;
            return false;
        }
        return true;
    }

    public void processTick(Level level, RecipeStorages storages, RecipeStateModel model) {
        for (IRecipeIngredientEntry input : this.inputs) {
            input.processTick(level, storages, model);
        }
    }

    public void process(Level level, RecipeStorages storages, RecipeStateModel model) {
        for (IRecipeIngredientEntry input : this.inputs) {
            input.process(level, storages, model);
        }
    }

    public void ditch(Level level, RecipeStorages storages, RecipeStateModel model) {
        for (IRecipeIngredientEntry input : this.inputs) {
            input.ditchRecipe(level, storages, model);
        }
    }

    public JsonArray debugRun(Level level, RecipeStorages storages, RecipeStateModel model) {
        JsonArray jsonArray = new JsonArray();
        for (IRecipeIngredientEntry input : this.inputs) {
            JsonObject expected = input.debugExpected(level, storages, model, new JsonObject());
            JsonObject inputRunJson = new JsonObject();
            inputRunJson.add("expected", (JsonElement)expected);
            jsonArray.add((JsonElement)inputRunJson);
        }
        return jsonArray;
    }
}

