/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.compat.jei.SlotGridEntry;
import io.ticticboom.mods.mm.recipe.RecipeConditions;
import io.ticticboom.mods.mm.recipe.RecipeInputs;
import io.ticticboom.mods.mm.recipe.RecipeOutputs;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import io.ticticboom.mods.mm.util.ParserUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record RecipeModel(ResourceLocation id, ResourceLocation structureId, int ticks, RecipeInputs inputs, RecipeOutputs outputs, List<SlotGridEntry> inputSlots, List<SlotGridEntry> outputSlots, RecipeConditions conditions, JsonObject config) {
    public static RecipeModel parse(JsonObject json, ResourceLocation id) {
        ResourceLocation structrueId = ParserUtils.parseId(json, "structureId");
        int ticks = json.get("ticks").getAsInt();
        RecipeInputs inputs = RecipeInputs.parse(json.getAsJsonArray("inputs"));
        RecipeOutputs outputs = RecipeOutputs.parse(json.getAsJsonArray("outputs"));
        RecipeConditions conditions = ParserUtils.parseOrDefault(json, "conditions", () -> new RecipeConditions(List.of()), j -> RecipeConditions.parse(j.getAsJsonArray("conditions")));
        return new RecipeModel(id, structrueId, ticks, inputs, outputs, new ArrayList<SlotGridEntry>(), new ArrayList<SlotGridEntry>(), conditions, json);
    }

    public String debugPath() {
        return this.id.m_135827_() + "/" + this.id.m_135815_() + ".json";
    }

    public boolean canProcess(Level level, RecipeStateModel model, RecipeStorages storages) {
        boolean canProcessResult;
        boolean canRun = this.conditions.canRun(level, model);
        if (!canRun) {
            model.setTickProgress(0);
            model.setCanProcess(false);
            return false;
        }
        boolean canInput = this.inputs.canProcess(level, storages, model);
        boolean canOutput = this.outputs.canProcess(level, storages, model);
        boolean bl = canProcessResult = canInput && canOutput;
        if (!canProcessResult) {
            model.setTickProgress(0);
        }
        model.setCanProcess(canProcessResult);
        return canProcessResult;
    }

    public void runTick(Level level, RecipeStateModel model, RecipeStorages storages) {
        this.inputs.processTick(level, storages, model);
        this.outputs.processTick(level, storages, model);
        model.proceedTick();
        model.setTickPercentage((double)model.getTickProgress() / (double)this.ticks * 100.0);
        if (model.getTickProgress() >= this.ticks) {
            model.setCanFinish(true);
        }
    }

    public void process(Level level, RecipeStateModel model, RecipeStorages storages) {
        this.inputs.process(level, storages, model);
        this.outputs.process(level, storages, model);
        model.setTickProgress(0);
        model.setCanFinish(false);
    }

    public void ditchRecipe(Level level, RecipeStateModel model, RecipeStorages storages) {
        this.inputs.ditch(level, storages, model);
        this.outputs.ditch(level, storages, model);
    }

    public JsonObject debugRun(Level level, RecipeStateModel model, RecipeStorages storages) {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id.toString());
        json.addProperty("structureId", this.structureId.toString());
        json.addProperty("ticks", (Number)this.ticks);
        json.add("inputs", (JsonElement)this.inputs.debugRun(level, storages, model));
        json.add("outputs", (JsonElement)this.outputs.debugRun(level, storages, model));
        json.add("portStorages", (JsonElement)storages.debug());
        return json;
    }
}

