/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.recipe.MachineRecipeManager;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import io.ticticboom.mods.mm.recipe.output.IRecipeOutputEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.Level;

public record RecipeOutputs(List<IRecipeOutputEntry> outputs) {
    public static RecipeOutputs parse(JsonArray json) {
        ArrayList<IRecipeOutputEntry> outputs = new ArrayList<IRecipeOutputEntry>();
        for (JsonElement elem : json) {
            JsonObject entryJson = elem.getAsJsonObject();
            outputs.add(MachineRecipeManager.parseOutputEntry(entryJson));
        }
        return new RecipeOutputs(outputs);
    }

    public boolean canProcess(Level level, RecipeStorages storages, RecipeStateModel model) {
        for (IRecipeOutputEntry output : this.outputs) {
            if (output.canOutput(level, storages, model)) continue;
            return false;
        }
        return true;
    }

    public void process(Level level, RecipeStorages storages, RecipeStateModel model) {
        for (IRecipeOutputEntry output : this.outputs) {
            output.output(level, storages, model);
        }
    }

    public void processTick(Level level, RecipeStorages storages, RecipeStateModel model) {
        for (IRecipeOutputEntry output : this.outputs) {
            output.processTick(level, storages, model);
        }
    }

    public void ditch(Level level, RecipeStorages storages, RecipeStateModel model) {
        for (IRecipeOutputEntry output : this.outputs) {
            output.ditchRecipe(level, storages, model);
        }
    }

    public JsonArray debugRun(Level level, RecipeStorages storages, RecipeStateModel model) {
        JsonArray jsonArray = new JsonArray();
        for (IRecipeOutputEntry output : this.outputs) {
            JsonObject expected = output.debugExpected(level, storages, model, new JsonObject());
            JsonObject inputRunJson = new JsonObject();
            inputRunJson.add("expected", (JsonElement)expected);
            jsonArray.add((JsonElement)inputRunJson);
        }
        return jsonArray;
    }
}

