/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.port.IPortStorage;
import java.util.ArrayList;
import java.util.List;

public record RecipeStorages(List<IPortStorage> inputStorages, List<IPortStorage> outputStorages) {
    public <T extends IPortStorage> List<T> getInputStorages(Class<T> clz) {
        return this.getStorages(clz, this.inputStorages);
    }

    public <T extends IPortStorage> List<T> getOutputStorages(Class<T> clz) {
        return this.getStorages(clz, this.outputStorages);
    }

    private <T extends IPortStorage> List<T> getStorages(Class<T> clz, List<IPortStorage> storages) {
        ArrayList<IPortStorage> result = new ArrayList<IPortStorage>();
        for (IPortStorage storage : storages) {
            if (!clz.isAssignableFrom(storage.getClass())) continue;
            result.add(storage);
        }
        return result;
    }

    public JsonObject debug() {
        JsonArray inputsJson = new JsonArray();
        JsonArray outputsJson = new JsonArray();
        for (IPortStorage inputStorage : this.inputStorages) {
            inputsJson.add((JsonElement)inputStorage.debugDump());
        }
        for (IPortStorage outputStorage : this.outputStorages) {
            outputsJson.add((JsonElement)outputStorage.debugDump());
        }
        JsonObject json = new JsonObject();
        json.add("inputs", (JsonElement)inputsJson);
        json.add("outputs", (JsonElement)outputsJson);
        return json;
    }
}

