/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.setup.loader;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.ticticboom.mods.mm.Ref;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public abstract class AbstractConfigLoader<TModel> {
    protected abstract String getConfigPath();

    protected abstract List<TModel> parseModels(List<JsonObject> var1);

    protected abstract void registerModels(List<TModel> var1);

    public void load() {
        List<JsonObject> jsons = this.getJsons();
        List<TModel> models = this.parseModels(jsons);
        this.registerModels(models);
    }

    private List<JsonObject> getJsons() {
        Path root = FMLPaths.CONFIGDIR.get().resolve("mm").resolve(this.getConfigPath());
        if (!Files.exists(root, new LinkOption[0])) {
            Files.createDirectories(root, new FileAttribute[0]);
        }
        return Files.walk(root, FileVisitOption.FOLLOW_LINKS).filter(x -> x.toString().endsWith(".json")).map(AbstractConfigLoader::parseJson).toList();
    }

    private static JsonObject parseJson(Path path) {
        try {
            String file = Files.readString(path);
            return JsonParser.parseString((String)file).getAsJsonObject();
        }
        catch (IOException e) {
            Ref.LOG.fatal("Failed to read file {}", (Object)path);
            throw new RuntimeException(e);
        }
    }
}

