/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.blueprint.widgets;

import io.ticticboom.mods.mm.client.blueprint.event.YSliceChangeEvent;
import io.ticticboom.mods.mm.client.gui.GuiEventHandler;
import io.ticticboom.mods.mm.client.gui.event.ArrowOptionSelectChangeEvent;
import io.ticticboom.mods.mm.client.gui.util.GuiPos;
import io.ticticboom.mods.mm.client.gui.widgets.ArrowOptionSelectWidget;
import io.ticticboom.mods.mm.client.structure.GuiStructureRenderer;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.joml.Vector3i;

public class BlueprintViewYSliceWidget
extends ArrowOptionSelectWidget {
    public static final String offStateOption = "Y Slice: All";
    private static final int offStateIndex = 0;
    public final GuiEventHandler<YSliceChangeEvent> changeEmitter = new GuiEventHandler();
    private final StructureModel model;

    public BlueprintViewYSliceWidget(GuiPos pos, StructureModel model) {
        super(pos, BlueprintViewYSliceWidget.getOptions(model));
        this.model = model;
        ((ArrowOptionSelectWidget)this).changeEmitter.addListener(this::onChange);
    }

    private void onChange(ArrowOptionSelectChangeEvent event) {
        if (event.index() == 0) {
            this.changeEmitter.fireEvent(new YSliceChangeEvent(0, false));
            return;
        }
        GuiStructureRenderer guiRenderer = this.model.getGuiRenderer();
        Vector3i min = guiRenderer.getMinBound();
        int ySlice = min.y() + event.index() - 1;
        this.changeEmitter.fireEvent(new YSliceChangeEvent(ySlice, true));
    }

    private static List<String> getOptions(StructureModel model) {
        GuiStructureRenderer guiRenderer = model.getGuiRenderer();
        guiRenderer.init();
        Vector3i structureSize = guiRenderer.getStructureSize();
        int sliceCountMax = structureSize.y;
        ArrayList<String> result = new ArrayList<String>();
        if (sliceCountMax > 0) {
            List<String> layers = IntStream.rangeClosed(0, sliceCountMax).boxed().map(x -> "Y Slice: " + x).toList();
            result.addAll(layers);
        }
        result.add(0, offStateOption);
        return result;
    }
}

