/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.blueprint.widgets;

import io.ticticboom.mods.mm.client.blueprint.state.BlueprintStructureViewState;
import io.ticticboom.mods.mm.client.blueprint.widgets.BlueprintViewYSliceWidget;
import io.ticticboom.mods.mm.client.blueprint.widgets.BlueprintViewZoomWidget;
import io.ticticboom.mods.mm.client.gui.AbstractWidget;
import io.ticticboom.mods.mm.client.gui.GuiEventHandler;
import io.ticticboom.mods.mm.client.gui.util.GuiAlignment;
import io.ticticboom.mods.mm.client.gui.util.GuiPlacementHelper;
import io.ticticboom.mods.mm.client.gui.util.GuiPos;
import io.ticticboom.mods.mm.structure.StructureModel;

public class StructureViewOptionsWidget
extends AbstractWidget {
    private final GuiPlacementHelper guiHelper;
    private final StructureModel model;
    private final BlueprintStructureViewState viewModel = new BlueprintStructureViewState();
    public final GuiEventHandler<BlueprintStructureViewState> changeEmitter = new GuiEventHandler();

    public StructureViewOptionsWidget(GuiPos pos, StructureModel model) {
        super(pos);
        this.guiHelper = new GuiPlacementHelper(pos, 5);
        this.model = model;
        this.createYSlicer();
    }

    private void createYSlicer() {
        BlueprintViewYSliceWidget ySlicer = this.addWidget(new BlueprintViewYSliceWidget(this.guiHelper.offset(GuiAlignment.LEFT_TOP, GuiPos.of(0, 0, this.guiHelper.getGuiWidth(), 16)), this.model));
        ySlicer.changeEmitter.addListener(e -> {
            this.viewModel.setSlice(e.ySlice(), e.shouldSlice());
            this.changeEmitter.fireEvent(this.viewModel);
        });
    }

    private void createZoom() {
        int verticalSpacing = 20;
        BlueprintViewZoomWidget zoom = this.addWidget(new BlueprintViewZoomWidget(this.guiHelper.offset(GuiAlignment.LEFT_TOP, GuiPos.of(0, verticalSpacing, this.guiHelper.getGuiWidth(), 16))));
        zoom.changeEmitter.addListener(e -> {
            this.viewModel.setZoom(e.zoom());
            this.changeEmitter.fireEvent(this.viewModel);
        });
    }
}

