/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.gui.util;

import io.ticticboom.mods.mm.client.gui.util.GuiAlignment;
import io.ticticboom.mods.mm.client.gui.util.GuiBounds;
import io.ticticboom.mods.mm.client.gui.util.GuiCoord;
import io.ticticboom.mods.mm.client.gui.util.GuiPos;
import io.ticticboom.mods.mm.client.gui.util.GuiSize;
import io.ticticboom.mods.mm.client.gui.util.IGuiPlacementHelper;
import org.joml.Vector2i;

public class GuiPlacementHelper
implements IGuiPlacementHelper {
    private final int containerWidth;
    private final int containerHeight;
    private final int containerPadding;
    private final int guiTop;
    private final int guiBottom;
    private final int guiLeft;
    private final int guiRight;
    private final int guiWidth;
    private final int guiHeight;

    public GuiPlacementHelper(int containerWidth, int containerHeight, int containerPadding) {
        this(GuiPos.of(0, 0, containerWidth, containerHeight), containerPadding);
    }

    public GuiPlacementHelper(GuiPos pos, int padding) {
        this.containerWidth = pos.w();
        this.containerHeight = pos.h();
        this.containerPadding = padding;
        this.guiTop = pos.y() + padding;
        this.guiLeft = pos.x() + padding;
        this.guiHeight = this.containerHeight - this.containerPadding * 2;
        this.guiWidth = this.containerWidth - this.containerPadding * 2;
        this.guiBottom = this.guiTop + this.guiHeight;
        this.guiRight = this.guiLeft + this.guiWidth;
    }

    @Override
    public int getGuiCenterX() {
        return this.guiLeft + this.guiWidth / 2;
    }

    @Override
    public int getGuiCenterY() {
        return this.guiTop + this.guiHeight / 2;
    }

    @Override
    public GuiBounds getGuiBounds() {
        return new GuiBounds(this.guiLeft, this.guiTop, this.guiRight, this.guiBottom, this.guiWidth, this.guiHeight);
    }

    @Override
    public GuiPos getGuiPos() {
        return GuiPos.of(GuiCoord.of(this.guiLeft, this.guiTop), GuiSize.of(this.guiWidth, this.guiHeight));
    }

    @Override
    public Vector2i offset(GuiAlignment alignment, Vector2i offset) {
        return switch (alignment) {
            default -> throw new IncompatibleClassChangeError();
            case GuiAlignment.LEFT_TOP -> new Vector2i(this.getGuiLeft() + offset.x, this.getGuiTop() + offset.y);
            case GuiAlignment.RIGHT_TOP -> new Vector2i(this.getGuiRight() - offset.x, this.getGuiTop() + offset.y);
            case GuiAlignment.LEFT_BOTTOM -> new Vector2i(this.getGuiLeft() + offset.x, this.getGuiBottom() - offset.y);
            case GuiAlignment.RIGHT_BOTTOM -> new Vector2i(this.getGuiRight() - offset.x, this.getGuiBottom() - offset.y);
            case GuiAlignment.CENTER_TOP -> new Vector2i(this.getGuiCenterX() + offset.x, this.getGuiTop() + offset.y);
            case GuiAlignment.CENTER_BOTTOM -> new Vector2i(this.getGuiCenterX() + offset.x, this.getGuiBottom() - offset.y);
            case GuiAlignment.LEFT_CENTER -> new Vector2i(this.getGuiLeft() + offset.x, this.getGuiCenterY() + offset.y);
            case GuiAlignment.RIGHT_CENTER -> new Vector2i(this.getGuiRight() - offset.x, this.getGuiCenterY() + offset.y);
        };
    }

    @Override
    public GuiPos offset(GuiAlignment alignment, GuiPos pos) {
        GuiCoord coord = this.offset(alignment, pos.coord());
        GuiSize size = pos.size();
        return switch (alignment) {
            case GuiAlignment.RIGHT_TOP, GuiAlignment.RIGHT_CENTER -> this.createPos(coord.x() - size.w(), coord.y(), size);
            case GuiAlignment.LEFT_BOTTOM, GuiAlignment.CENTER_BOTTOM -> this.createPos(coord.x(), coord.y() - size.h(), size);
            case GuiAlignment.RIGHT_BOTTOM -> this.createPos(coord.x() - size.w(), coord.y() - size.h(), size);
            default -> this.createPos(coord.x(), coord.y(), size);
        };
    }

    private GuiPos createPos(int x, int y, GuiSize size) {
        return GuiPos.of(GuiCoord.of(x, y), size);
    }

    @Override
    public int getContainerWidth() {
        return this.containerWidth;
    }

    @Override
    public int getContainerHeight() {
        return this.containerHeight;
    }

    @Override
    public int getContainerPadding() {
        return this.containerPadding;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getGuiBottom() {
        return this.guiBottom;
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiRight() {
        return this.guiRight;
    }

    @Override
    public int getGuiWidth() {
        return this.guiWidth;
    }

    @Override
    public int getGuiHeight() {
        return this.guiHeight;
    }
}

