/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.client.structure;

import io.ticticboom.mods.mm.client.RenderUtil;
import io.ticticboom.mods.mm.client.blueprint.state.BlueprintStructureViewState;
import io.ticticboom.mods.mm.client.gui.util.GuiPos;
import io.ticticboom.mods.mm.client.structure.AutoTransform;
import io.ticticboom.mods.mm.client.structure.GuiBlockRenderer;
import io.ticticboom.mods.mm.client.structure.GuiRenderEnvSetup;
import io.ticticboom.mods.mm.client.structure.GuiStructureLayout;
import io.ticticboom.mods.mm.client.structure.PositionedCyclingBlockRenderer;
import io.ticticboom.mods.mm.client.structure.StructureRenderYSliceProcessor;
import io.ticticboom.mods.mm.client.structure.TickCycling;
import io.ticticboom.mods.mm.structure.StructureManager;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.joml.Vector3i;

public class GuiStructureRenderer {
    public static boolean shouldEnsureValidated = false;
    private final StructureModel model;
    private List<PositionedCyclingBlockRenderer> parts;
    private final GuiStructureLayout guiLayout;
    private final AutoTransform viewTransform;
    private final GuiRenderEnvSetup renderSetup = new GuiRenderEnvSetup();
    private final StructureRenderYSliceProcessor ySliceProcessor = new StructureRenderYSliceProcessor();
    private int renderZoomAdjustment = 0;
    private Vector3i structureSize = new Vector3i(0);
    private Vector3i minBound = new Vector3i(0);
    private Vector3i maxBound = new Vector3i(0);
    private boolean isInitialized = false;

    public GuiStructureRenderer(StructureModel model) {
        this.model = model;
        this.viewTransform = new AutoTransform(model);
        this.guiLayout = new GuiStructureLayout(model.layout());
        this.parts = new ArrayList<PositionedCyclingBlockRenderer>();
    }

    public void init() {
        if (!this.isInitialized) {
            this.model.layout().setup(this.model);
            this.parts = this.guiLayout.createBlockRenderers();
            this.parts.add(this.model.controllerUiRenderer());
            for (PositionedCyclingBlockRenderer part : this.parts) {
                ((TickCycling)part.part).setInterval(60);
            }
            this.getExtents();
            this.isInitialized = true;
        }
    }

    private void getExtents() {
        List<BlockPos> positions = this.parts.stream().map(x -> x.pos).toList();
        Integer minX = positions.stream().map(Vec3i::m_123341_).min(Integer::compareTo).orElse(0);
        Integer minY = positions.stream().map(Vec3i::m_123342_).min(Integer::compareTo).orElse(0);
        Integer minZ = positions.stream().map(Vec3i::m_123343_).min(Integer::compareTo).orElse(0);
        this.minBound = new Vector3i(minX.intValue(), minY.intValue(), minZ.intValue());
        Integer maxX = positions.stream().map(Vec3i::m_123341_).max(Integer::compareTo).orElse(0);
        Integer maxY = positions.stream().map(Vec3i::m_123342_).max(Integer::compareTo).orElse(0);
        Integer maxZ = positions.stream().map(Vec3i::m_123343_).max(Integer::compareTo).orElse(0);
        this.maxBound = new Vector3i(maxX.intValue(), maxY.intValue(), maxZ.intValue());
        int extentX = maxX - minX;
        int extentY = maxY - minY;
        int extentZ = maxZ - minZ;
        this.structureSize = new Vector3i(extentX, extentY, extentZ);
        this.renderZoomAdjustment = Math.max(extentX, Math.max(extentY, extentZ));
    }

    public void setViewport(GuiPos viewport) {
        this.renderSetup.setViewportPos(viewport);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY) {
        if (shouldEnsureValidated) {
            StructureManager.validateAllPieces();
            shouldEnsureValidated = false;
        }
        this.viewTransform.run(mouseX, mouseY);
        this.renderSetup.preRender((float)this.viewTransform.getYRotation(), (float)this.viewTransform.getXRotation(), this.renderZoomAdjustment, this.viewTransform.getViewTransform());
        for (PositionedCyclingBlockRenderer part : this.parts) {
            if (!this.canRenderPart(part)) continue;
            ((TickCycling)part.part).tick();
            GuiBlockRenderer next = (GuiBlockRenderer)((TickCycling)part.part).next();
            next.render(gfx, mouseX, mouseY, this.viewTransform);
        }
        this.renderSetup.postRender();
        RenderUtil.resetViewport();
    }

    public void setupViewState(BlueprintStructureViewState state) {
        this.ySliceProcessor.setShouldSlice(state.isShouldSlice());
        this.ySliceProcessor.setYSlice(state.getYSlice());
    }

    private boolean canRenderPart(PositionedCyclingBlockRenderer part) {
        return this.ySliceProcessor.canProcess(part);
    }

    public void resetTransforms() {
        this.viewTransform.reset();
    }

    public Vector3i getStructureSize() {
        return this.structureSize;
    }

    public Vector3i getMinBound() {
        return this.minBound;
    }

    public Vector3i getMaxBound() {
        return this.maxBound;
    }
}

